// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_connection_state.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"

namespace blink {



constexpr const char* const V8SmartCardConnectionState::string_table_[] = {
"absent", "present", "swallowed", "powered", "negotiable", "t0", "t1", "raw"
};

V8SmartCardConnectionState V8SmartCardConnectionState::Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state) {
  const auto& result = bindings::FindIndexInEnumStringTable(isolate, value, string_table_, "SmartCardConnectionState", exception_state);
return result.has_value() ? V8SmartCardConnectionState(static_cast<Enum>(result.value())) : V8SmartCardConnectionState();
}

std::optional<V8SmartCardConnectionState> V8SmartCardConnectionState::Create(const String& value) {
  const auto& result = bindings::FindIndexInEnumStringTable(value, string_table_);
if (!result)
  return std::nullopt;
return V8SmartCardConnectionState(static_cast<Enum>(result.value()));
}


static_assert(std::is_trivially_copyable<V8SmartCardConnectionState>::value, "");






}  // namespace blink
