// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCStats : public bindings::DictionaryBase {
  
  public:
static RTCStats* Create() {
  return MakeGarbageCollected<RTCStats>();
}
static RTCStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCStats>(isolate);
}
static RTCStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCStats();
explicit  RTCStats(v8::Isolate* isolate);

bool hasId() const {
  return true;
}
const String& id() const {
  return member_id_;
}
void setId(const String& value);
void setId(String&& value);

bool hasTimestamp() const {
  return true;
}
double timestamp() const {
  return member_timestamp_;
}
void setTimestamp(double value) {
  member_timestamp_ = value;
}

bool hasType() const {
  return true;
}
V8RTCStatsType type() const {
  return member_type_;
}
void setType(V8RTCStatsType value) {
  member_type_ = value;
}
void setType(V8RTCStatsType::Enum value) {
  member_type_ = V8RTCStatsType(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_id_;
double member_timestamp_;
V8RTCStatsType member_type_{static_cast<V8RTCStatsType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_STATS_H_
