// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_STREAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_STREAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCRtpStreamStats : public RTCStats {
  
  public:
static RTCRtpStreamStats* Create() {
  return MakeGarbageCollected<RTCRtpStreamStats>();
}
static RTCRtpStreamStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpStreamStats>(isolate);
}
static RTCRtpStreamStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpStreamStats();
explicit  RTCRtpStreamStats(v8::Isolate* isolate);

bool hasCodecId() const {
  return has_codec_id_;
}
const String& codecId() const {
  DCHECK(hasCodecId());
return member_codec_id_;
}
String getCodecIdOr(const String& fallback_value) const;
String getCodecIdOr(String&& fallback_value) const;
void setCodecId(const String& value);
void setCodecId(String&& value);

bool hasKind() const {
  return true;
}
const String& kind() const {
  return member_kind_;
}
void setKind(const String& value);
void setKind(String&& value);

bool hasMediaType() const {
  return has_media_type_;
}
const String& mediaType() const {
  DCHECK(hasMediaType());
return member_media_type_;
}
String getMediaTypeOr(const String& fallback_value) const;
String getMediaTypeOr(String&& fallback_value) const;
void setMediaType(const String& value);
void setMediaType(String&& value);

bool hasSsrc() const {
  return true;
}
uint32_t ssrc() const {
  return member_ssrc_;
}
void setSsrc(uint32_t value) {
  member_ssrc_ = value;
}

bool hasTransportId() const {
  return has_transport_id_;
}
const String& transportId() const {
  DCHECK(hasTransportId());
return member_transport_id_;
}
String getTransportIdOr(const String& fallback_value) const;
String getTransportIdOr(String&& fallback_value) const;
void setTransportId(const String& value);
void setTransportId(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_codec_id_ = false;
bool has_media_type_ = false;
bool has_transport_id_ = false;

String member_codec_id_;
String member_kind_;
String member_media_type_;
uint32_t member_ssrc_;
String member_transport_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_STREAM_STATS_H_
