// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_capabilities.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_codec_capability.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_header_extension_capability.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"codecs",
"headerExtensions",
};


}  // namespace 

RTCRtpCapabilities* RTCRtpCapabilities::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCRtpCapabilities* dictionary = MakeGarbageCollected<RTCRtpCapabilities>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCRtpCapabilities";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCRtpCapabilities::RTCRtpCapabilities() {
  
}

 RTCRtpCapabilities::RTCRtpCapabilities(v8::Isolate* isolate) {
  
}



void RTCRtpCapabilities::setCodecs(const HeapVector<Member<RTCRtpCodecCapability>>& value) {
  member_codecs_ = value;
}

void RTCRtpCapabilities::setCodecs(HeapVector<Member<RTCRtpCodecCapability>>&& value) {
  member_codecs_ = std::move(value);
}




void RTCRtpCapabilities::setHeaderExtensions(const HeapVector<Member<RTCRtpHeaderExtensionCapability>>& value) {
  member_header_extensions_ = value;
}

void RTCRtpCapabilities::setHeaderExtensions(HeapVector<Member<RTCRtpHeaderExtensionCapability>>&& value) {
  member_header_extensions_ = std::move(value);
}



void RTCRtpCapabilities::Trace(Visitor* visitor) const {
  visitor->Trace(member_codecs_);
visitor->Trace(member_header_extensions_);
bindings::DictionaryBase::Trace(visitor);
}

void RTCRtpCapabilities::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCRtpCapabilities::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCodecs()) {
  values[0] = ToV8Traits<IDLSequence<RTCRtpCodecCapability>>::ToV8(script_state, member_codecs_);
DCHECK(!values[0].IsEmpty());
}
if (hasHeaderExtensions()) {
  values[1] = ToV8Traits<IDLSequence<RTCRtpHeaderExtensionCapability>>::ToV8(script_state, member_header_extensions_);
DCHECK(!values[1].IsEmpty());
}
}

const void* RTCRtpCapabilities::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCRtpCapabilities::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCRtpCapabilities::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCRtpCapabilities";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("codecs");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCRtpCodecCapability>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_codecs_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("headerExtensions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCRtpHeaderExtensionCapability>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_header_extensions_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCRtpCapabilities::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
