// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_AUDIO_FRAME_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_AUDIO_FRAME_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RTCEncodedAudioFrameMetadata;

class MODULES_EXPORT RTCEncodedAudioFrameOptions : public bindings::InputDictionaryBase {
  
  public:
static RTCEncodedAudioFrameOptions* Create() {
  return MakeGarbageCollected<RTCEncodedAudioFrameOptions>();
}
static RTCEncodedAudioFrameOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCEncodedAudioFrameOptions>(isolate);
}
static RTCEncodedAudioFrameOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCEncodedAudioFrameOptions();
explicit  RTCEncodedAudioFrameOptions(v8::Isolate* isolate);

bool hasMetadata() const {
  return has_metadata_;
}
RTCEncodedAudioFrameMetadata* metadata() const {
  DCHECK(hasMetadata());
return member_metadata_.Get();
}
RTCEncodedAudioFrameMetadata* getMetadataOr(RTCEncodedAudioFrameMetadata* fallback_value) const {
  if (!hasMetadata()) {
  return fallback_value;
}
return member_metadata_.Get();
}
void setMetadata(RTCEncodedAudioFrameMetadata* value) {
  member_metadata_ = value;
has_metadata_ = true;
DCHECK(member_metadata_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_metadata_ = false;

Member<RTCEncodedAudioFrameMetadata> member_metadata_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ENCODED_AUDIO_FRAME_OPTIONS_H_
