// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_dtls_transport_state.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"

namespace blink {



constexpr const char* const V8RTCDtlsTransportState::string_table_[] = {
"new", "connecting", "connected", "closed", "failed"
};

V8RTCDtlsTransportState V8RTCDtlsTransportState::Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state) {
  const auto& result = bindings::FindIndexInEnumStringTable(isolate, value, string_table_, "RTCDtlsTransportState", exception_state);
return result.has_value() ? V8RTCDtlsTransportState(static_cast<Enum>(result.value())) : V8RTCDtlsTransportState();
}

std::optional<V8RTCDtlsTransportState> V8RTCDtlsTransportState::Create(const String& value) {
  const auto& result = bindings::FindIndexInEnumStringTable(value, string_table_);
if (!result)
  return std::nullopt;
return V8RTCDtlsTransportState(static_cast<Enum>(result.value()));
}


static_assert(std::is_trivially_copyable<V8RTCDtlsTransportState>::value, "");






}  // namespace blink
