// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CODEC_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CODEC_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCCodecStats : public RTCStats {
  
  public:
static RTCCodecStats* Create() {
  return MakeGarbageCollected<RTCCodecStats>();
}
static RTCCodecStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCCodecStats>(isolate);
}
static RTCCodecStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCCodecStats();
explicit  RTCCodecStats(v8::Isolate* isolate);

bool hasChannels() const {
  return has_channels_;
}
uint32_t channels() const {
  DCHECK(hasChannels());
return member_channels_;
}
uint32_t getChannelsOr(uint32_t fallback_value) const {
  if (!hasChannels()) {
  return fallback_value;
}
return member_channels_;
}
void setChannels(uint32_t value) {
  member_channels_ = value;
has_channels_ = true;
}

bool hasClockRate() const {
  return has_clock_rate_;
}
uint32_t clockRate() const {
  DCHECK(hasClockRate());
return member_clock_rate_;
}
uint32_t getClockRateOr(uint32_t fallback_value) const {
  if (!hasClockRate()) {
  return fallback_value;
}
return member_clock_rate_;
}
void setClockRate(uint32_t value) {
  member_clock_rate_ = value;
has_clock_rate_ = true;
}

bool hasMimeType() const {
  return true;
}
const String& mimeType() const {
  return member_mime_type_;
}
void setMimeType(const String& value);
void setMimeType(String&& value);

bool hasPayloadType() const {
  return true;
}
uint32_t payloadType() const {
  return member_payload_type_;
}
void setPayloadType(uint32_t value) {
  member_payload_type_ = value;
}

bool hasSdpFmtpLine() const {
  return has_sdp_fmtp_line_;
}
const String& sdpFmtpLine() const {
  DCHECK(hasSdpFmtpLine());
return member_sdp_fmtp_line_;
}
String getSdpFmtpLineOr(const String& fallback_value) const;
String getSdpFmtpLineOr(String&& fallback_value) const;
void setSdpFmtpLine(const String& value);
void setSdpFmtpLine(String&& value);

bool hasTransportId() const {
  return true;
}
const String& transportId() const {
  return member_transport_id_;
}
void setTransportId(const String& value);
void setTransportId(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_channels_ = false;
bool has_clock_rate_ = false;
bool has_sdp_fmtp_line_ = false;

uint32_t member_channels_;
uint32_t member_clock_rate_;
String member_mime_type_;
uint32_t member_payload_type_;
String member_sdp_fmtp_line_;
String member_transport_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_CODEC_STATS_H_
