// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_AUDIO_PLAYOUT_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_AUDIO_PLAYOUT_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCAudioPlayoutStats : public RTCStats {
  
  public:
static RTCAudioPlayoutStats* Create() {
  return MakeGarbageCollected<RTCAudioPlayoutStats>();
}
static RTCAudioPlayoutStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCAudioPlayoutStats>(isolate);
}
static RTCAudioPlayoutStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCAudioPlayoutStats();
explicit  RTCAudioPlayoutStats(v8::Isolate* isolate);

bool hasKind() const {
  return true;
}
const String& kind() const {
  return member_kind_;
}
void setKind(const String& value);
void setKind(String&& value);

bool hasSynthesizedSamplesDuration() const {
  return has_synthesized_samples_duration_;
}
double synthesizedSamplesDuration() const {
  DCHECK(hasSynthesizedSamplesDuration());
return member_synthesized_samples_duration_;
}
double getSynthesizedSamplesDurationOr(double fallback_value) const {
  if (!hasSynthesizedSamplesDuration()) {
  return fallback_value;
}
return member_synthesized_samples_duration_;
}
void setSynthesizedSamplesDuration(double value) {
  member_synthesized_samples_duration_ = value;
has_synthesized_samples_duration_ = true;
}

bool hasSynthesizedSamplesEvents() const {
  return has_synthesized_samples_events_;
}
uint32_t synthesizedSamplesEvents() const {
  DCHECK(hasSynthesizedSamplesEvents());
return member_synthesized_samples_events_;
}
uint32_t getSynthesizedSamplesEventsOr(uint32_t fallback_value) const {
  if (!hasSynthesizedSamplesEvents()) {
  return fallback_value;
}
return member_synthesized_samples_events_;
}
void setSynthesizedSamplesEvents(uint32_t value) {
  member_synthesized_samples_events_ = value;
has_synthesized_samples_events_ = true;
}

bool hasTotalPlayoutDelay() const {
  return has_total_playout_delay_;
}
double totalPlayoutDelay() const {
  DCHECK(hasTotalPlayoutDelay());
return member_total_playout_delay_;
}
double getTotalPlayoutDelayOr(double fallback_value) const {
  if (!hasTotalPlayoutDelay()) {
  return fallback_value;
}
return member_total_playout_delay_;
}
void setTotalPlayoutDelay(double value) {
  member_total_playout_delay_ = value;
has_total_playout_delay_ = true;
}

bool hasTotalSamplesCount() const {
  return has_total_samples_count_;
}
uint64_t totalSamplesCount() const {
  DCHECK(hasTotalSamplesCount());
return member_total_samples_count_;
}
uint64_t getTotalSamplesCountOr(uint64_t fallback_value) const {
  if (!hasTotalSamplesCount()) {
  return fallback_value;
}
return member_total_samples_count_;
}
void setTotalSamplesCount(uint64_t value) {
  member_total_samples_count_ = value;
has_total_samples_count_ = true;
}

bool hasTotalSamplesDuration() const {
  return has_total_samples_duration_;
}
double totalSamplesDuration() const {
  DCHECK(hasTotalSamplesDuration());
return member_total_samples_duration_;
}
double getTotalSamplesDurationOr(double fallback_value) const {
  if (!hasTotalSamplesDuration()) {
  return fallback_value;
}
return member_total_samples_duration_;
}
void setTotalSamplesDuration(double value) {
  member_total_samples_duration_ = value;
has_total_samples_duration_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_synthesized_samples_duration_ = false;
bool has_synthesized_samples_events_ = false;
bool has_total_playout_delay_ = false;
bool has_total_samples_count_ = false;
bool has_total_samples_duration_ = false;

String member_kind_;
double member_synthesized_samples_duration_;
uint32_t member_synthesized_samples_events_;
double member_total_playout_delay_;
uint64_t member_total_samples_count_;
double member_total_samples_duration_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_AUDIO_PLAYOUT_STATS_H_
