// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_audio_playout_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"kind",
"synthesizedSamplesDuration",
"synthesizedSamplesEvents",
"totalPlayoutDelay",
"totalSamplesCount",
"totalSamplesDuration",
};


}  // namespace 

RTCAudioPlayoutStats* RTCAudioPlayoutStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCAudioPlayoutStats* dictionary = MakeGarbageCollected<RTCAudioPlayoutStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCAudioPlayoutStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCAudioPlayoutStats::RTCAudioPlayoutStats() {
  
}

 RTCAudioPlayoutStats::RTCAudioPlayoutStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}



void RTCAudioPlayoutStats::setKind(const String& value) {
  member_kind_ = value;
}

void RTCAudioPlayoutStats::setKind(String&& value) {
  member_kind_ = std::move(value);
}






































void RTCAudioPlayoutStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCAudioPlayoutStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCAudioPlayoutStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasKind()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_kind_);
DCHECK(!values[0].IsEmpty());
}
if (hasSynthesizedSamplesDuration()) {
  values[1] = ToV8Traits<IDLDouble>::ToV8(script_state, member_synthesized_samples_duration_);
DCHECK(!values[1].IsEmpty());
}
if (hasSynthesizedSamplesEvents()) {
  values[2] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_synthesized_samples_events_);
DCHECK(!values[2].IsEmpty());
}
if (hasTotalPlayoutDelay()) {
  values[3] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_playout_delay_);
DCHECK(!values[3].IsEmpty());
}
if (hasTotalSamplesCount()) {
  values[4] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_total_samples_count_);
DCHECK(!values[4].IsEmpty());
}
if (hasTotalSamplesDuration()) {
  values[5] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_samples_duration_);
DCHECK(!values[5].IsEmpty());
}
}

const void* RTCAudioPlayoutStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCAudioPlayoutStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCAudioPlayoutStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCAudioPlayoutStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("kind");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_kind_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("synthesizedSamplesDuration");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_synthesized_samples_duration_, member_synthesized_samples_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("synthesizedSamplesEvents");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_synthesized_samples_events_, member_synthesized_samples_events_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalPlayoutDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_total_playout_delay_, member_total_playout_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSamplesCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_total_samples_count_, member_total_samples_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSamplesDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_total_samples_duration_, member_total_samples_duration_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCAudioPlayoutStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
