// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REGISTRATION_RESPONSE_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REGISTRATION_RESPONSE_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsClientOutputsJSON;
class AuthenticatorAttestationResponseJSON;
class ExceptionState;

class MODULES_EXPORT RegistrationResponseJSON : public bindings::DictionaryBase {
  
  public:
static RegistrationResponseJSON* Create() {
  return MakeGarbageCollected<RegistrationResponseJSON>();
}
static RegistrationResponseJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RegistrationResponseJSON>(isolate);
}
static RegistrationResponseJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RegistrationResponseJSON();
explicit  RegistrationResponseJSON(v8::Isolate* isolate);

bool hasAuthenticatorAttachment() const {
  return has_authenticator_attachment_;
}
const String& authenticatorAttachment() const {
  DCHECK(hasAuthenticatorAttachment());
return member_authenticator_attachment_;
}
String getAuthenticatorAttachmentOr(const String& fallback_value) const;
String getAuthenticatorAttachmentOr(String&& fallback_value) const;
void setAuthenticatorAttachment(const String& value);
void setAuthenticatorAttachment(String&& value);

bool hasClientExtensionResults() const {
  return true;
}
AuthenticationExtensionsClientOutputsJSON* clientExtensionResults() const {
  return member_client_extension_results_.Get();
}
void setClientExtensionResults(AuthenticationExtensionsClientOutputsJSON* value) {
  member_client_extension_results_ = value;
DCHECK(member_client_extension_results_);
}

bool hasId() const {
  return true;
}
const String& id() const {
  return member_id_;
}
void setId(const String& value);
void setId(String&& value);

bool hasRawId() const {
  return true;
}
const String& rawId() const {
  return member_raw_id_;
}
void setRawId(const String& value);
void setRawId(String&& value);

bool hasResponse() const {
  return true;
}
AuthenticatorAttestationResponseJSON* response() const {
  return member_response_.Get();
}
void setResponse(AuthenticatorAttestationResponseJSON* value) {
  member_response_ = value;
DCHECK(member_response_);
}

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_authenticator_attachment_ = false;

String member_authenticator_attachment_;
Member<AuthenticationExtensionsClientOutputsJSON> member_client_extension_results_;
String member_id_;
String member_raw_id_;
Member<AuthenticatorAttestationResponseJSON> member_response_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_REGISTRATION_RESPONSE_JS_ON_H_
