// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREADER_CREATE_CORE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREADER_CREATE_CORE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ProofreaderCreateCoreOptions : public bindings::InputDictionaryBase {
  
  public:
static ProofreaderCreateCoreOptions* Create() {
  return MakeGarbageCollected<ProofreaderCreateCoreOptions>();
}
static ProofreaderCreateCoreOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProofreaderCreateCoreOptions>(isolate);
}
static ProofreaderCreateCoreOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProofreaderCreateCoreOptions();
explicit  ProofreaderCreateCoreOptions(v8::Isolate* isolate);

bool hasCorrectionExplanationLanguage() const {
  return has_correction_explanation_language_;
}
const String& correctionExplanationLanguage() const {
  DCHECK(hasCorrectionExplanationLanguage());
return member_correction_explanation_language_;
}
String getCorrectionExplanationLanguageOr(const String& fallback_value) const;
String getCorrectionExplanationLanguageOr(String&& fallback_value) const;
void setCorrectionExplanationLanguage(const String& value);
void setCorrectionExplanationLanguage(String&& value);

bool hasExpectedInputLanguages() const {
  return has_expected_input_languages_;
}
const Vector<String>& expectedInputLanguages() const {
  DCHECK(hasExpectedInputLanguages());
return member_expected_input_languages_;
}
Vector<String> getExpectedInputLanguagesOr(const Vector<String>& fallback_value) const;
Vector<String> getExpectedInputLanguagesOr(Vector<String>&& fallback_value) const;
void setExpectedInputLanguages(const Vector<String>& value);
void setExpectedInputLanguages(Vector<String>&& value);

bool hasIncludeCorrectionExplanations() const {
  return true;
}
bool includeCorrectionExplanations() const {
  return member_include_correction_explanations_;
}
void setIncludeCorrectionExplanations(bool value) {
  member_include_correction_explanations_ = value;
}

bool hasIncludeCorrectionTypes() const {
  return true;
}
bool includeCorrectionTypes() const {
  return member_include_correction_types_;
}
void setIncludeCorrectionTypes(bool value) {
  member_include_correction_types_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_correction_explanation_language_ = false;
bool has_expected_input_languages_ = false;

String member_correction_explanation_language_;
Vector<String> member_expected_input_languages_;
bool member_include_correction_explanations_{false};
bool member_include_correction_types_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PROOFREADER_CREATE_CORE_OPTIONS_H_
