// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESENTATION_CONNECTION_AVAILABLE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESENTATION_CONNECTION_AVAILABLE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class PresentationConnection;

class MODULES_EXPORT PresentationConnectionAvailableEventInit : public EventInit {
  
  public:
static PresentationConnectionAvailableEventInit* Create() {
  return MakeGarbageCollected<PresentationConnectionAvailableEventInit>();
}
static PresentationConnectionAvailableEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PresentationConnectionAvailableEventInit>(isolate);
}
static PresentationConnectionAvailableEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PresentationConnectionAvailableEventInit();
explicit  PresentationConnectionAvailableEventInit(v8::Isolate* isolate);

bool hasConnection() const {
  return true;
}
PresentationConnection* connection() const {
  return member_connection_.Get();
}
void setConnection(PresentationConnection* value) {
  member_connection_ = value;
DCHECK(member_connection_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<PresentationConnection> member_connection_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRESENTATION_CONNECTION_AVAILABLE_EVENT_INIT_H_
