// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_handler_response.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_address_init.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"details",
"methodName",
"payerEmail",
"payerName",
"payerPhone",
"shippingAddress",
"shippingOption",
};


}  // namespace 

PaymentHandlerResponse* PaymentHandlerResponse::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PaymentHandlerResponse* dictionary = MakeGarbageCollected<PaymentHandlerResponse>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PaymentHandlerResponse";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PaymentHandlerResponse::PaymentHandlerResponse() {
  
}

 PaymentHandlerResponse::PaymentHandlerResponse(v8::Isolate* isolate) {
  
}










String PaymentHandlerResponse::getMethodNameOr(const String& fallback_value) const {
  if (!hasMethodName()) {
  return fallback_value;
}
return member_method_name_;
}

String PaymentHandlerResponse::getMethodNameOr(String&& fallback_value) const {
  if (!hasMethodName()) {
  return std::move(fallback_value);
}
return member_method_name_;
}

void PaymentHandlerResponse::setMethodName(const String& value) {
  member_method_name_ = value;
has_method_name_ = true;
}

void PaymentHandlerResponse::setMethodName(String&& value) {
  member_method_name_ = std::move(value);
has_method_name_ = true;
}




String PaymentHandlerResponse::getPayerEmailOr(const String& fallback_value) const {
  if (!hasPayerEmail()) {
  return fallback_value;
}
return member_payer_email_;
}

String PaymentHandlerResponse::getPayerEmailOr(String&& fallback_value) const {
  if (!hasPayerEmail()) {
  return std::move(fallback_value);
}
return member_payer_email_;
}

void PaymentHandlerResponse::setPayerEmail(const String& value) {
  member_payer_email_ = value;
has_payer_email_ = true;
}

void PaymentHandlerResponse::setPayerEmail(String&& value) {
  member_payer_email_ = std::move(value);
has_payer_email_ = true;
}




String PaymentHandlerResponse::getPayerNameOr(const String& fallback_value) const {
  if (!hasPayerName()) {
  return fallback_value;
}
return member_payer_name_;
}

String PaymentHandlerResponse::getPayerNameOr(String&& fallback_value) const {
  if (!hasPayerName()) {
  return std::move(fallback_value);
}
return member_payer_name_;
}

void PaymentHandlerResponse::setPayerName(const String& value) {
  member_payer_name_ = value;
has_payer_name_ = true;
}

void PaymentHandlerResponse::setPayerName(String&& value) {
  member_payer_name_ = std::move(value);
has_payer_name_ = true;
}




String PaymentHandlerResponse::getPayerPhoneOr(const String& fallback_value) const {
  if (!hasPayerPhone()) {
  return fallback_value;
}
return member_payer_phone_;
}

String PaymentHandlerResponse::getPayerPhoneOr(String&& fallback_value) const {
  if (!hasPayerPhone()) {
  return std::move(fallback_value);
}
return member_payer_phone_;
}

void PaymentHandlerResponse::setPayerPhone(const String& value) {
  member_payer_phone_ = value;
has_payer_phone_ = true;
}

void PaymentHandlerResponse::setPayerPhone(String&& value) {
  member_payer_phone_ = std::move(value);
has_payer_phone_ = true;
}











String PaymentHandlerResponse::getShippingOptionOr(const String& fallback_value) const {
  if (!hasShippingOption()) {
  return fallback_value;
}
return member_shipping_option_;
}

String PaymentHandlerResponse::getShippingOptionOr(String&& fallback_value) const {
  if (!hasShippingOption()) {
  return std::move(fallback_value);
}
return member_shipping_option_;
}

void PaymentHandlerResponse::setShippingOption(const String& value) {
  member_shipping_option_ = value;
has_shipping_option_ = true;
}

void PaymentHandlerResponse::setShippingOption(String&& value) {
  member_shipping_option_ = std::move(value);
has_shipping_option_ = true;
}



void PaymentHandlerResponse::Trace(Visitor* visitor) const {
  visitor->Trace(member_details_);
visitor->Trace(member_shipping_address_);
bindings::DictionaryBase::Trace(visitor);
}

void PaymentHandlerResponse::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PaymentHandlerResponse::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDetails()) {
  values[0] = ToV8Traits<IDLObject>::ToV8(script_state, member_details_);
DCHECK(!values[0].IsEmpty());
}
if (hasMethodName()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_method_name_);
DCHECK(!values[1].IsEmpty());
}
if (hasPayerEmail()) {
  values[2] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_payer_email_);
DCHECK(!values[2].IsEmpty());
}
if (hasPayerName()) {
  values[3] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_payer_name_);
DCHECK(!values[3].IsEmpty());
}
if (hasPayerPhone()) {
  values[4] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_payer_phone_);
DCHECK(!values[4].IsEmpty());
}
if (hasShippingAddress()) {
  values[5] = ToV8Traits<AddressInit>::ToV8(script_state, member_shipping_address_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasShippingOption()) {
  values[6] = ToV8Traits<IDLNullable<IDLString>>::ToV8(script_state, member_shipping_option_);
DCHECK(!values[6].IsEmpty());
}
}

const void* PaymentHandlerResponse::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PaymentHandlerResponse::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PaymentHandlerResponse::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PaymentHandlerResponse";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("details");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_details_, member_details_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("methodName");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_method_name_, member_method_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("payerEmail");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_payer_email_, member_payer_email_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("payerName");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_payer_name_, member_payer_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("payerPhone");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_payer_phone_, member_payer_phone_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shippingAddress");
if (!bindings::GetDictionaryMemberFromV8Object<AddressInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_shipping_address_, member_shipping_address_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("shippingOption");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_shipping_option_, member_shipping_option_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PaymentHandlerResponse::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
