// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_payer_errors.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"email",
"name",
"phone",
};


}  // namespace 

PayerErrors* PayerErrors::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PayerErrors* dictionary = MakeGarbageCollected<PayerErrors>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PayerErrors";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PayerErrors::PayerErrors() {
  
}

 PayerErrors::PayerErrors(v8::Isolate* isolate) {
  
}



String PayerErrors::getEmailOr(const String& fallback_value) const {
  if (!hasEmail()) {
  return fallback_value;
}
return member_email_;
}

String PayerErrors::getEmailOr(String&& fallback_value) const {
  if (!hasEmail()) {
  return std::move(fallback_value);
}
return member_email_;
}

void PayerErrors::setEmail(const String& value) {
  member_email_ = value;
has_email_ = true;
}

void PayerErrors::setEmail(String&& value) {
  member_email_ = std::move(value);
has_email_ = true;
}




String PayerErrors::getNameOr(const String& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

String PayerErrors::getNameOr(String&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void PayerErrors::setName(const String& value) {
  member_name_ = value;
has_name_ = true;
}

void PayerErrors::setName(String&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}




String PayerErrors::getPhoneOr(const String& fallback_value) const {
  if (!hasPhone()) {
  return fallback_value;
}
return member_phone_;
}

String PayerErrors::getPhoneOr(String&& fallback_value) const {
  if (!hasPhone()) {
  return std::move(fallback_value);
}
return member_phone_;
}

void PayerErrors::setPhone(const String& value) {
  member_phone_ = value;
has_phone_ = true;
}

void PayerErrors::setPhone(String&& value) {
  member_phone_ = std::move(value);
has_phone_ = true;
}



void PayerErrors::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void PayerErrors::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PayerErrors";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("email");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_email_, member_email_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("phone");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_phone_, member_phone_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PayerErrors::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
