// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_password_credential_data.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"iconURL",
"name",
"password",
};


}  // namespace 

PasswordCredentialData* PasswordCredentialData::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PasswordCredentialData* dictionary = MakeGarbageCollected<PasswordCredentialData>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PasswordCredentialData";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PasswordCredentialData::PasswordCredentialData() {
  
}

 PasswordCredentialData::PasswordCredentialData(v8::Isolate* isolate) : CredentialData(isolate) {
  
}



String PasswordCredentialData::getIconURLOr(const String& fallback_value) const {
  if (!hasIconURL()) {
  return fallback_value;
}
return member_icon_url_;
}

String PasswordCredentialData::getIconURLOr(String&& fallback_value) const {
  if (!hasIconURL()) {
  return std::move(fallback_value);
}
return member_icon_url_;
}

void PasswordCredentialData::setIconURL(const String& value) {
  member_icon_url_ = value;
has_icon_url_ = true;
}

void PasswordCredentialData::setIconURL(String&& value) {
  member_icon_url_ = std::move(value);
has_icon_url_ = true;
}




String PasswordCredentialData::getNameOr(const String& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

String PasswordCredentialData::getNameOr(String&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void PasswordCredentialData::setName(const String& value) {
  member_name_ = value;
has_name_ = true;
}

void PasswordCredentialData::setName(String&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}




void PasswordCredentialData::setPassword(const String& value) {
  member_password_ = value;
}

void PasswordCredentialData::setPassword(String&& value) {
  member_password_ = std::move(value);
}



void PasswordCredentialData::Trace(Visitor* visitor) const {
  CredentialData::Trace(visitor);
}

void PasswordCredentialData::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
CredentialData::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "PasswordCredentialData";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("iconURL");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_icon_url_, member_icon_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("password");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_password_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PasswordCredentialData::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
