// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NOTIFICATION_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NOTIFICATION_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class Notification;

class MODULES_EXPORT NotificationEventInit : public ExtendableEventInit {
  
  public:
static NotificationEventInit* Create() {
  return MakeGarbageCollected<NotificationEventInit>();
}
static NotificationEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NotificationEventInit>(isolate);
}
static NotificationEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NotificationEventInit();
explicit  NotificationEventInit(v8::Isolate* isolate);

bool hasAction() const {
  return true;
}
const String& action() const {
  return member_action_;
}
void setAction(const String& value);
void setAction(String&& value);

bool hasNotification() const {
  return true;
}
Notification* notification() const {
  return member_notification_.Get();
}
void setNotification(Notification* value) {
  member_notification_ = value;
DCHECK(member_notification_);
}

bool hasReply() const {
  return true;
}
const String& reply() const {
  return member_reply_;
}
void setReply(const String& value);
void setReply(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_action_{""};
Member<Notification> member_notification_;
String member_reply_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_NOTIFICATION_EVENT_INIT_H_
