// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_SPLIT_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_SPLIT_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLTensorLimits;

class MODULES_EXPORT MLSplitSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLSplitSupportLimits* Create() {
  return MakeGarbageCollected<MLSplitSupportLimits>();
}
static MLSplitSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLSplitSupportLimits>(isolate);
}
static MLSplitSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLSplitSupportLimits();
explicit  MLSplitSupportLimits(v8::Isolate* isolate);

bool hasInput() const {
  return has_input_;
}
MLTensorLimits* input() const {
  DCHECK(hasInput());
return member_input_.Get();
}
MLTensorLimits* getInputOr(MLTensorLimits* fallback_value) const {
  if (!hasInput()) {
  return fallback_value;
}
return member_input_.Get();
}
void setInput(MLTensorLimits* value) {
  member_input_ = value;
has_input_ = true;
DCHECK(member_input_);
}

bool hasOutputs() const {
  return has_outputs_;
}
MLTensorLimits* outputs() const {
  DCHECK(hasOutputs());
return member_outputs_.Get();
}
MLTensorLimits* getOutputsOr(MLTensorLimits* fallback_value) const {
  if (!hasOutputs()) {
  return fallback_value;
}
return member_outputs_.Get();
}
void setOutputs(MLTensorLimits* value) {
  member_outputs_ = value;
has_outputs_ = true;
DCHECK(member_outputs_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_input_ = false;
bool has_outputs_ = false;

Member<MLTensorLimits> member_input_;
Member<MLTensorLimits> member_outputs_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_SPLIT_SUPPORT_LIMITS_H_
