// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_RESAMPLE_2D_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_RESAMPLE_2D_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_interpolation_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLResample2dOptions : public MLOperatorOptions {
  
  public:
static MLResample2dOptions* Create() {
  return MakeGarbageCollected<MLResample2dOptions>();
}
static MLResample2dOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLResample2dOptions>(isolate);
}
static MLResample2dOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLResample2dOptions();
explicit  MLResample2dOptions(v8::Isolate* isolate);

bool hasAxes() const {
  return has_axes_;
}
const Vector<uint32_t>& axes() const {
  DCHECK(hasAxes());
return member_axes_;
}
Vector<uint32_t> getAxesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getAxesOr(Vector<uint32_t>&& fallback_value) const;
void setAxes(const Vector<uint32_t>& value);
void setAxes(Vector<uint32_t>&& value);

bool hasMode() const {
  return true;
}
V8MLInterpolationMode mode() const {
  return member_mode_;
}
void setMode(V8MLInterpolationMode value) {
  member_mode_ = value;
}
void setMode(V8MLInterpolationMode::Enum value) {
  member_mode_ = V8MLInterpolationMode(value);
}

bool hasScales() const {
  return has_scales_;
}
const Vector<float>& scales() const {
  DCHECK(hasScales());
return member_scales_;
}
Vector<float> getScalesOr(const Vector<float>& fallback_value) const;
Vector<float> getScalesOr(Vector<float>&& fallback_value) const;
void setScales(const Vector<float>& value);
void setScales(Vector<float>&& value);

bool hasSizes() const {
  return has_sizes_;
}
const Vector<uint32_t>& sizes() const {
  DCHECK(hasSizes());
return member_sizes_;
}
Vector<uint32_t> getSizesOr(const Vector<uint32_t>& fallback_value) const;
Vector<uint32_t> getSizesOr(Vector<uint32_t>&& fallback_value) const;
void setSizes(const Vector<uint32_t>& value);
void setSizes(Vector<uint32_t>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_axes_ = false;
bool has_scales_ = false;
bool has_sizes_ = false;

Vector<uint32_t> member_axes_;
V8MLInterpolationMode member_mode_{V8MLInterpolationMode::Enum::kNearestNeighbor};
Vector<float> member_scales_;
Vector<uint32_t> member_sizes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_RESAMPLE_2D_OPTIONS_H_
