// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_PAD_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_PAD_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_padding_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionBigintOrUnrestrictedDouble;

class MODULES_EXPORT MLPadOptions : public MLOperatorOptions {
  
  public:
static MLPadOptions* Create() {
  return MakeGarbageCollected<MLPadOptions>();
}
static MLPadOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLPadOptions>(isolate);
}
static MLPadOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLPadOptions();
explicit  MLPadOptions(v8::Isolate* isolate);

bool hasMode() const {
  return true;
}
V8MLPaddingMode mode() const {
  return member_mode_;
}
void setMode(V8MLPaddingMode value) {
  member_mode_ = value;
}
void setMode(V8MLPaddingMode::Enum value) {
  member_mode_ = V8MLPaddingMode(value);
}

bool hasValue() const {
  return true;
}
V8UnionBigintOrUnrestrictedDouble* value() const {
  return member_value_.Get();
}
void setValue(V8UnionBigintOrUnrestrictedDouble* value) {
  member_value_ = value;
DCHECK(member_value_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8MLPaddingMode member_mode_{V8MLPaddingMode::Enum::kConstant};
Member<V8UnionBigintOrUnrestrictedDouble> member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_PAD_OPTIONS_H_
