// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SETTINGS_RANGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SETTINGS_RANGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaSettingsRange : public bindings::DictionaryBase {
  
  public:
static MediaSettingsRange* Create() {
  return MakeGarbageCollected<MediaSettingsRange>();
}
static MediaSettingsRange* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaSettingsRange>(isolate);
}
static MediaSettingsRange* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaSettingsRange();
explicit  MediaSettingsRange(v8::Isolate* isolate);

bool hasMax() const {
  return has_max_;
}
double max() const {
  DCHECK(hasMax());
return member_max_;
}
double getMaxOr(double fallback_value) const {
  if (!hasMax()) {
  return fallback_value;
}
return member_max_;
}
void setMax(double value) {
  member_max_ = value;
has_max_ = true;
}

bool hasMin() const {
  return has_min_;
}
double min() const {
  DCHECK(hasMin());
return member_min_;
}
double getMinOr(double fallback_value) const {
  if (!hasMin()) {
  return fallback_value;
}
return member_min_;
}
void setMin(double value) {
  member_min_ = value;
has_min_ = true;
}

bool hasStep() const {
  return has_step_;
}
double step() const {
  DCHECK(hasStep());
return member_step_;
}
double getStepOr(double fallback_value) const {
  if (!hasStep()) {
  return fallback_value;
}
return member_step_;
}
void setStep(double value) {
  member_step_ = value;
has_step_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_max_ = false;
bool has_min_ = false;
bool has_step_ = false;

double member_max_;
double member_min_;
double member_step_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_SETTINGS_RANGE_H_
