// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_MESSAGE_CONTENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_MESSAGE_CONTENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_message_type.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AudioBuffer;
class Blob;
class ExceptionState;
class HTMLAudioElement;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
class ImageData;
class OffscreenCanvas;
class SVGImageElement;
class V8LanguageModelMessageValue;
class V8UnionArrayBufferOrArrayBufferView;
class V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame;
class VideoFrame;

class MODULES_EXPORT LanguageModelMessageContent : public bindings::InputDictionaryBase {
  
  public:
static LanguageModelMessageContent* Create() {
  return MakeGarbageCollected<LanguageModelMessageContent>();
}
static LanguageModelMessageContent* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LanguageModelMessageContent>(isolate);
}
static LanguageModelMessageContent* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LanguageModelMessageContent();
explicit  LanguageModelMessageContent(v8::Isolate* isolate);

bool hasType() const {
  return true;
}
V8LanguageModelMessageType type() const {
  return member_type_;
}
void setType(V8LanguageModelMessageType value) {
  member_type_ = value;
}
void setType(V8LanguageModelMessageType::Enum value) {
  member_type_ = V8LanguageModelMessageType(value);
}

bool hasValue() const {
  return true;
}
V8LanguageModelMessageValue* value() const {
  return member_value_.Get();
}
void setValue(V8LanguageModelMessageValue* value) {
  member_value_ = value;
DCHECK(member_value_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8LanguageModelMessageType member_type_{static_cast<V8LanguageModelMessageType::Enum>(0)};
Member<V8LanguageModelMessageValue> member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_MESSAGE_CONTENT_H_
