// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_MESSAGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_MESSAGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_message_role.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class LanguageModelMessageContent;
class V8UnionLanguageModelMessageContentSequenceOrString;

class MODULES_EXPORT LanguageModelMessage : public bindings::InputDictionaryBase {
  
  public:
static LanguageModelMessage* Create() {
  return MakeGarbageCollected<LanguageModelMessage>();
}
static LanguageModelMessage* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<LanguageModelMessage>(isolate);
}
static LanguageModelMessage* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  LanguageModelMessage();
explicit  LanguageModelMessage(v8::Isolate* isolate);

bool hasContent() const {
  return true;
}
V8UnionLanguageModelMessageContentSequenceOrString* content() const {
  return member_content_.Get();
}
void setContent(V8UnionLanguageModelMessageContentSequenceOrString* value) {
  member_content_ = value;
DCHECK(member_content_);
}

bool hasPrefix() const {
  return true;
}
bool prefix() const {
  return member_prefix_;
}
void setPrefix(bool value) {
  member_prefix_ = value;
}

bool hasRole() const {
  return true;
}
V8LanguageModelMessageRole role() const {
  return member_role_;
}
void setRole(V8LanguageModelMessageRole value) {
  member_role_ = value;
}
void setRole(V8LanguageModelMessageRole::Enum value) {
  member_role_ = V8LanguageModelMessageRole(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionLanguageModelMessageContentSequenceOrString> member_content_;
bool member_prefix_{false};
V8LanguageModelMessageRole member_role_{static_cast<V8LanguageModelMessageRole::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_LANGUAGE_MODEL_MESSAGE_H_
