// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_json_web_key.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rsa_other_primes_info.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"alg",
"crv",
"d",
"dp",
"dq",
"e",
"ext",
"k",
"key_ops",
"kty",
"n",
"oth",
"p",
"q",
"qi",
"use",
"x",
"y",
};


}  // namespace 

JsonWebKey* JsonWebKey::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  JsonWebKey* dictionary = MakeGarbageCollected<JsonWebKey>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "JsonWebKey";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 JsonWebKey::JsonWebKey() {
  
}

 JsonWebKey::JsonWebKey(v8::Isolate* isolate) {
  
}



String JsonWebKey::getAlgOr(const String& fallback_value) const {
  if (!hasAlg()) {
  return fallback_value;
}
return member_alg_;
}

String JsonWebKey::getAlgOr(String&& fallback_value) const {
  if (!hasAlg()) {
  return std::move(fallback_value);
}
return member_alg_;
}

void JsonWebKey::setAlg(const String& value) {
  member_alg_ = value;
has_alg_ = true;
}

void JsonWebKey::setAlg(String&& value) {
  member_alg_ = std::move(value);
has_alg_ = true;
}




String JsonWebKey::getCrvOr(const String& fallback_value) const {
  if (!hasCrv()) {
  return fallback_value;
}
return member_crv_;
}

String JsonWebKey::getCrvOr(String&& fallback_value) const {
  if (!hasCrv()) {
  return std::move(fallback_value);
}
return member_crv_;
}

void JsonWebKey::setCrv(const String& value) {
  member_crv_ = value;
has_crv_ = true;
}

void JsonWebKey::setCrv(String&& value) {
  member_crv_ = std::move(value);
has_crv_ = true;
}




String JsonWebKey::getDOr(const String& fallback_value) const {
  if (!hasD()) {
  return fallback_value;
}
return member_d_;
}

String JsonWebKey::getDOr(String&& fallback_value) const {
  if (!hasD()) {
  return std::move(fallback_value);
}
return member_d_;
}

void JsonWebKey::setD(const String& value) {
  member_d_ = value;
has_d_ = true;
}

void JsonWebKey::setD(String&& value) {
  member_d_ = std::move(value);
has_d_ = true;
}




String JsonWebKey::getDpOr(const String& fallback_value) const {
  if (!hasDp()) {
  return fallback_value;
}
return member_dp_;
}

String JsonWebKey::getDpOr(String&& fallback_value) const {
  if (!hasDp()) {
  return std::move(fallback_value);
}
return member_dp_;
}

void JsonWebKey::setDp(const String& value) {
  member_dp_ = value;
has_dp_ = true;
}

void JsonWebKey::setDp(String&& value) {
  member_dp_ = std::move(value);
has_dp_ = true;
}




String JsonWebKey::getDqOr(const String& fallback_value) const {
  if (!hasDq()) {
  return fallback_value;
}
return member_dq_;
}

String JsonWebKey::getDqOr(String&& fallback_value) const {
  if (!hasDq()) {
  return std::move(fallback_value);
}
return member_dq_;
}

void JsonWebKey::setDq(const String& value) {
  member_dq_ = value;
has_dq_ = true;
}

void JsonWebKey::setDq(String&& value) {
  member_dq_ = std::move(value);
has_dq_ = true;
}




String JsonWebKey::getEOr(const String& fallback_value) const {
  if (!hasE()) {
  return fallback_value;
}
return member_e_;
}

String JsonWebKey::getEOr(String&& fallback_value) const {
  if (!hasE()) {
  return std::move(fallback_value);
}
return member_e_;
}

void JsonWebKey::setE(const String& value) {
  member_e_ = value;
has_e_ = true;
}

void JsonWebKey::setE(String&& value) {
  member_e_ = std::move(value);
has_e_ = true;
}











String JsonWebKey::getKOr(const String& fallback_value) const {
  if (!hasK()) {
  return fallback_value;
}
return member_k_;
}

String JsonWebKey::getKOr(String&& fallback_value) const {
  if (!hasK()) {
  return std::move(fallback_value);
}
return member_k_;
}

void JsonWebKey::setK(const String& value) {
  member_k_ = value;
has_k_ = true;
}

void JsonWebKey::setK(String&& value) {
  member_k_ = std::move(value);
has_k_ = true;
}




Vector<String> JsonWebKey::getKeyOpsOr(const Vector<String>& fallback_value) const {
  if (!hasKeyOps()) {
  return fallback_value;
}
return member_key_ops_;
}

Vector<String> JsonWebKey::getKeyOpsOr(Vector<String>&& fallback_value) const {
  if (!hasKeyOps()) {
  return std::move(fallback_value);
}
return member_key_ops_;
}

void JsonWebKey::setKeyOps(const Vector<String>& value) {
  member_key_ops_ = value;
has_key_ops_ = true;
}

void JsonWebKey::setKeyOps(Vector<String>&& value) {
  member_key_ops_ = std::move(value);
has_key_ops_ = true;
}




String JsonWebKey::getKtyOr(const String& fallback_value) const {
  if (!hasKty()) {
  return fallback_value;
}
return member_kty_;
}

String JsonWebKey::getKtyOr(String&& fallback_value) const {
  if (!hasKty()) {
  return std::move(fallback_value);
}
return member_kty_;
}

void JsonWebKey::setKty(const String& value) {
  member_kty_ = value;
has_kty_ = true;
}

void JsonWebKey::setKty(String&& value) {
  member_kty_ = std::move(value);
has_kty_ = true;
}




String JsonWebKey::getNOr(const String& fallback_value) const {
  if (!hasN()) {
  return fallback_value;
}
return member_n_;
}

String JsonWebKey::getNOr(String&& fallback_value) const {
  if (!hasN()) {
  return std::move(fallback_value);
}
return member_n_;
}

void JsonWebKey::setN(const String& value) {
  member_n_ = value;
has_n_ = true;
}

void JsonWebKey::setN(String&& value) {
  member_n_ = std::move(value);
has_n_ = true;
}




HeapVector<Member<RsaOtherPrimesInfo>> JsonWebKey::getOthOr(const HeapVector<Member<RsaOtherPrimesInfo>>& fallback_value) const {
  if (!hasOth()) {
  return fallback_value;
}
return member_oth_;
}

HeapVector<Member<RsaOtherPrimesInfo>> JsonWebKey::getOthOr(HeapVector<Member<RsaOtherPrimesInfo>>&& fallback_value) const {
  if (!hasOth()) {
  return std::move(fallback_value);
}
return member_oth_;
}

void JsonWebKey::setOth(const HeapVector<Member<RsaOtherPrimesInfo>>& value) {
  member_oth_ = value;
has_oth_ = true;
}

void JsonWebKey::setOth(HeapVector<Member<RsaOtherPrimesInfo>>&& value) {
  member_oth_ = std::move(value);
has_oth_ = true;
}




String JsonWebKey::getPOr(const String& fallback_value) const {
  if (!hasP()) {
  return fallback_value;
}
return member_p_;
}

String JsonWebKey::getPOr(String&& fallback_value) const {
  if (!hasP()) {
  return std::move(fallback_value);
}
return member_p_;
}

void JsonWebKey::setP(const String& value) {
  member_p_ = value;
has_p_ = true;
}

void JsonWebKey::setP(String&& value) {
  member_p_ = std::move(value);
has_p_ = true;
}




String JsonWebKey::getQOr(const String& fallback_value) const {
  if (!hasQ()) {
  return fallback_value;
}
return member_q_;
}

String JsonWebKey::getQOr(String&& fallback_value) const {
  if (!hasQ()) {
  return std::move(fallback_value);
}
return member_q_;
}

void JsonWebKey::setQ(const String& value) {
  member_q_ = value;
has_q_ = true;
}

void JsonWebKey::setQ(String&& value) {
  member_q_ = std::move(value);
has_q_ = true;
}




String JsonWebKey::getQiOr(const String& fallback_value) const {
  if (!hasQi()) {
  return fallback_value;
}
return member_qi_;
}

String JsonWebKey::getQiOr(String&& fallback_value) const {
  if (!hasQi()) {
  return std::move(fallback_value);
}
return member_qi_;
}

void JsonWebKey::setQi(const String& value) {
  member_qi_ = value;
has_qi_ = true;
}

void JsonWebKey::setQi(String&& value) {
  member_qi_ = std::move(value);
has_qi_ = true;
}




String JsonWebKey::getUseOr(const String& fallback_value) const {
  if (!hasUse()) {
  return fallback_value;
}
return member_use_;
}

String JsonWebKey::getUseOr(String&& fallback_value) const {
  if (!hasUse()) {
  return std::move(fallback_value);
}
return member_use_;
}

void JsonWebKey::setUse(const String& value) {
  member_use_ = value;
has_use_ = true;
}

void JsonWebKey::setUse(String&& value) {
  member_use_ = std::move(value);
has_use_ = true;
}




String JsonWebKey::getXOr(const String& fallback_value) const {
  if (!hasX()) {
  return fallback_value;
}
return member_x_;
}

String JsonWebKey::getXOr(String&& fallback_value) const {
  if (!hasX()) {
  return std::move(fallback_value);
}
return member_x_;
}

void JsonWebKey::setX(const String& value) {
  member_x_ = value;
has_x_ = true;
}

void JsonWebKey::setX(String&& value) {
  member_x_ = std::move(value);
has_x_ = true;
}




String JsonWebKey::getYOr(const String& fallback_value) const {
  if (!hasY()) {
  return fallback_value;
}
return member_y_;
}

String JsonWebKey::getYOr(String&& fallback_value) const {
  if (!hasY()) {
  return std::move(fallback_value);
}
return member_y_;
}

void JsonWebKey::setY(const String& value) {
  member_y_ = value;
has_y_ = true;
}

void JsonWebKey::setY(String&& value) {
  member_y_ = std::move(value);
has_y_ = true;
}



void JsonWebKey::Trace(Visitor* visitor) const {
  visitor->Trace(member_oth_);
bindings::InputDictionaryBase::Trace(visitor);
}

void JsonWebKey::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "JsonWebKey";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("alg");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_alg_, member_alg_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("crv");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_crv_, member_crv_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("d");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_d_, member_d_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_dp_, member_dp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dq");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_dq_, member_dq_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("e");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_e_, member_e_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ext");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_ext_, member_ext_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("k");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_k_, member_k_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("key_ops");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_key_ops_, member_key_ops_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("kty");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_kty_, member_kty_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("n");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_n_, member_n_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("oth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RsaOtherPrimesInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_oth_, member_oth_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("p");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_p_, member_p_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("q");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_q_, member_q_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("qi");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_qi_, member_qi_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("use");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_use_, member_use_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("x");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_x_, member_x_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("y");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_y_, member_y_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> JsonWebKey::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
