// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_POINT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_POINT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT HandwritingPoint : public bindings::DictionaryBase {
  
  public:
static HandwritingPoint* Create() {
  return MakeGarbageCollected<HandwritingPoint>();
}
static HandwritingPoint* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HandwritingPoint>(isolate);
}
static HandwritingPoint* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HandwritingPoint();
explicit  HandwritingPoint(v8::Isolate* isolate);

bool hasT() const {
  return has_t_;
}
uint64_t t() const {
  DCHECK(hasT());
return member_t_;
}
uint64_t getTOr(uint64_t fallback_value) const {
  if (!hasT()) {
  return fallback_value;
}
return member_t_;
}
void setT(uint64_t value) {
  member_t_ = value;
has_t_ = true;
}

bool hasX() const {
  return true;
}
double x() const {
  return member_x_;
}
void setX(double value) {
  member_x_ = value;
}

bool hasY() const {
  return true;
}
double y() const {
  return member_y_;
}
void setY(double value) {
  member_y_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_t_ = false;

uint64_t member_t_;
double member_x_;
double member_y_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_POINT_H_
