// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_dimension.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view_dimension.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUExtent3DDict;
class V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence;

class MODULES_EXPORT GPUTextureDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUTextureDescriptor* Create() {
  return MakeGarbageCollected<GPUTextureDescriptor>();
}
static GPUTextureDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUTextureDescriptor>(isolate);
}
static GPUTextureDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUTextureDescriptor();
explicit  GPUTextureDescriptor(v8::Isolate* isolate);

bool hasDimension() const {
  return true;
}
V8GPUTextureDimension dimension() const {
  return member_dimension_;
}
void setDimension(V8GPUTextureDimension value) {
  member_dimension_ = value;
}
void setDimension(V8GPUTextureDimension::Enum value) {
  member_dimension_ = V8GPUTextureDimension(value);
}

bool hasFormat() const {
  return true;
}
V8GPUTextureFormat format() const {
  return member_format_;
}
void setFormat(V8GPUTextureFormat value) {
  member_format_ = value;
}
void setFormat(V8GPUTextureFormat::Enum value) {
  member_format_ = V8GPUTextureFormat(value);
}

bool hasMipLevelCount() const {
  return true;
}
uint32_t mipLevelCount() const {
  return member_mip_level_count_;
}
void setMipLevelCount(uint32_t value) {
  member_mip_level_count_ = value;
}

bool hasSampleCount() const {
  return true;
}
uint32_t sampleCount() const {
  return member_sample_count_;
}
void setSampleCount(uint32_t value) {
  member_sample_count_ = value;
}

bool hasSize() const {
  return true;
}
V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence* size() const {
  return member_size_.Get();
}
void setSize(V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence* value) {
  member_size_ = value;
DCHECK(member_size_);
}

bool hasTextureBindingViewDimension() const {
  return has_texture_binding_view_dimension_;
}
V8GPUTextureViewDimension textureBindingViewDimension() const {
  DCHECK(hasTextureBindingViewDimension());
return member_texture_binding_view_dimension_;
}
V8GPUTextureViewDimension getTextureBindingViewDimensionOr(V8GPUTextureViewDimension fallback_value) const {
  if (!hasTextureBindingViewDimension()) {
  return fallback_value;
}
return member_texture_binding_view_dimension_;
}
void setTextureBindingViewDimension(V8GPUTextureViewDimension value) {
  member_texture_binding_view_dimension_ = value;
has_texture_binding_view_dimension_ = true;
}
void setTextureBindingViewDimension(V8GPUTextureViewDimension::Enum value) {
  member_texture_binding_view_dimension_ = V8GPUTextureViewDimension(value);
has_texture_binding_view_dimension_ = true;
}

bool hasUsage() const {
  return true;
}
uint32_t usage() const {
  return member_usage_;
}
void setUsage(uint32_t value) {
  member_usage_ = value;
}

bool hasViewFormats() const {
  return true;
}
const Vector<V8GPUTextureFormat>& viewFormats() const {
  return member_view_formats_;
}
void setViewFormats(const Vector<V8GPUTextureFormat>& value);
void setViewFormats(Vector<V8GPUTextureFormat>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_texture_binding_view_dimension_ = false;

V8GPUTextureDimension member_dimension_{V8GPUTextureDimension::Enum::k2D};
V8GPUTextureFormat member_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
uint32_t member_mip_level_count_{1};
uint32_t member_sample_count_{1};
Member<V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence> member_size_;
V8GPUTextureViewDimension member_texture_binding_view_dimension_{static_cast<V8GPUTextureViewDimension::Enum>(0)};
uint32_t member_usage_;
Vector<V8GPUTextureFormat> member_view_formats_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_DESCRIPTOR_H_
