// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_BUNDLE_ENCODER_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_BUNDLE_ENCODER_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_layout.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPURenderBundleEncoderDescriptor : public GPURenderPassLayout {
  
  public:
static GPURenderBundleEncoderDescriptor* Create() {
  return MakeGarbageCollected<GPURenderBundleEncoderDescriptor>();
}
static GPURenderBundleEncoderDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderBundleEncoderDescriptor>(isolate);
}
static GPURenderBundleEncoderDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderBundleEncoderDescriptor();
explicit  GPURenderBundleEncoderDescriptor(v8::Isolate* isolate);

bool hasDepthReadOnly() const {
  return true;
}
bool depthReadOnly() const {
  return member_depth_read_only_;
}
void setDepthReadOnly(bool value) {
  member_depth_read_only_ = value;
}

bool hasStencilReadOnly() const {
  return true;
}
bool stencilReadOnly() const {
  return member_stencil_read_only_;
}
void setStencilReadOnly(bool value) {
  member_stencil_read_only_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPURenderPassLayout::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_depth_read_only_{false};
bool member_stencil_read_only_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_BUNDLE_ENCODER_DESCRIPTOR_H_
