// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COMPUTE_PIPELINE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COMPUTE_PIPELINE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUProgrammableStage;

class MODULES_EXPORT GPUComputePipelineDescriptor : public GPUPipelineDescriptorBase {
  
  public:
static GPUComputePipelineDescriptor* Create() {
  return MakeGarbageCollected<GPUComputePipelineDescriptor>();
}
static GPUComputePipelineDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUComputePipelineDescriptor>(isolate);
}
static GPUComputePipelineDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUComputePipelineDescriptor();
explicit  GPUComputePipelineDescriptor(v8::Isolate* isolate);

bool hasCompute() const {
  return true;
}
GPUProgrammableStage* compute() const {
  return member_compute_.Get();
}
void setCompute(GPUProgrammableStage* value) {
  member_compute_ = value;
DCHECK(member_compute_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUPipelineDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<GPUProgrammableStage> member_compute_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COMPUTE_PIPELINE_DESCRIPTOR_H_
