// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_encoder.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_buffer_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pass_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pass_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_extent_3d_dict.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texel_copy_buffer_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texel_copy_texture_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_gpuextent3ddict_unsignedlongenforcerangesequence.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_command_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_command_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_compute_pass_encoder.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_query_set.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_render_pass_encoder.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8GPUCommandEncoder::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope());
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8GPUCommandEncoder::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8GPUCommandEncoder::InstallInterfaceTemplate,
    nullptr,
    "GPUCommandEncoder",
    nullptr,
    V8GPUCommandEncoder::kThisTag,
    V8GPUCommandEncoder::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& GPUCommandEncoder::wrapper_type_info_ =
    V8GPUCommandEncoder::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, GPUCommandEncoder>::value,
    "GPUCommandEncoder inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_gpu_command_encoder {


void LabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_label_Getter");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.label.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->label();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LabelAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_label_Setter");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.label.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLabel(arg1_value);

}

void BeginComputePassOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_beginComputePass");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.beginComputePass");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<GPUComputePassDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
ExceptionState exception_state(isolate);
if (info[0]->IsUndefined()) {
  arg1_descriptor = GPUComputePassDescriptor::Create();
} else {
  arg1_descriptor = NativeValueTraits<GPUComputePassDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->beginComputePass(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUComputePassEncoder, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void BeginRenderPassOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_beginRenderPass");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.beginRenderPass");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_descriptor = NativeValueTraits<GPURenderPassDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->beginRenderPass(arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPURenderPassEncoder, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void ClearBufferOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_buffer, uint64_t v8_arg2_offset, uint64_t v8_arg3_size, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_offset = v8_arg2_offset;
auto&& arg3_size = v8_arg3_size;
blink_receiver->clearBuffer(arg1_buffer, arg2_offset, arg3_size);
}

void ClearBufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_buffer, uint64_t v8_arg2_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_offset = v8_arg2_offset;
blink_receiver->clearBuffer(arg1_buffer, arg2_offset);
}

void ClearBufferOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_offset{0};
blink_receiver->clearBuffer(arg1_buffer, arg2_offset);
}

void ClearBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_clearBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.clearBuffer");




if (info.Length() < 1) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLongLongEnforceRange>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_offset{0};
if (!info[1]->IsUndefined()) {
  arg2_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->clearBuffer(arg1_buffer, arg2_offset);
break;
}
auto&& arg3_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearBuffer(arg1_buffer, arg2_offset, arg3_size);
} while (false);

}

void CopyBufferToBufferOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_source, v8::Local<v8::Value> v8_arg2_destination, uint64_t v8_arg3_size, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_source, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 1, v8_arg2_destination, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_size = v8_arg3_size;
blink_receiver->copyBufferToBuffer(arg1_source, arg2_destination, arg3_size, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void CopyBufferToBufferOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_source, v8::Local<v8::Value> v8_arg2_destination, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_source, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 1, v8_arg2_destination, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyBufferToBuffer(arg1_source, arg2_destination, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void CopyBufferToBufferOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_source, uint64_t v8_arg2_source_offset, v8::Local<v8::Value> v8_arg3_destination, uint64_t v8_arg4_destination_offset, uint64_t v8_arg5_size, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_source, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_source_offset = v8_arg2_source_offset;
auto&& arg3_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 2, v8_arg3_destination, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_destination_offset = v8_arg4_destination_offset;
auto&& arg5_size = v8_arg5_size;
blink_receiver->copyBufferToBuffer(arg1_source, arg2_source_offset, arg3_destination, arg4_destination_offset, arg5_size, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void CopyBufferToBufferOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_source, uint64_t v8_arg2_source_offset, v8::Local<v8::Value> v8_arg3_destination, uint64_t v8_arg4_destination_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);



v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, v8_arg1_source, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_source_offset = v8_arg2_source_offset;
auto&& arg3_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 2, v8_arg3_destination, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_destination_offset = v8_arg4_destination_offset;
blink_receiver->copyBufferToBuffer(arg1_source, arg2_source_offset, arg3_destination, arg4_destination_offset, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void CopyBufferToBufferOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_source = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->copyBufferToBuffer(arg1_source, arg2_destination, exception_state);
break;
}
auto&& arg3_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyBufferToBuffer(arg1_source, arg2_destination, arg3_size, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void CopyBufferToBufferOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_source = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_source_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_destination_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 4) {
  blink_receiver->copyBufferToBuffer(arg1_source, arg2_source_offset, arg3_destination, arg4_destination_offset, exception_state);
break;
}
auto&& arg5_size = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyBufferToBuffer(arg1_source, arg2_source_offset, arg3_destination, arg4_destination_offset, arg5_size, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void CopyBufferToBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_copyBufferToBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.copyBufferToBuffer");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return CopyBufferToBufferOperationOverload2(info);
}
if (arg_count == 4) {
  return CopyBufferToBufferOperationOverload2(info);
}
if (arg_count == 3) {
  return CopyBufferToBufferOperationOverload1(info);
}
if (arg_count == 2) {
  return CopyBufferToBufferOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CopyBufferToTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_copyBufferToTexture");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.copyBufferToTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUTexelCopyBufferInfo>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_destination = NativeValueTraits<GPUTexelCopyTextureInfo>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_copy_size = NativeValueTraits<V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyBufferToTexture(arg1_source, arg2_destination, arg3_copy_size, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void CopyTextureToBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_copyTextureToBuffer");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.copyTextureToBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUTexelCopyTextureInfo>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_destination = NativeValueTraits<GPUTexelCopyBufferInfo>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_copy_size = NativeValueTraits<V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTextureToBuffer(arg1_source, arg2_destination, arg3_copy_size, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void CopyTextureToTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_copyTextureToTexture");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.copyTextureToTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_source = NativeValueTraits<GPUTexelCopyTextureInfo>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_destination = NativeValueTraits<GPUTexelCopyTextureInfo>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_copy_size = NativeValueTraits<V8UnionGPUExtent3DDictOrUnsignedLongEnforceRangeSequence>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTextureToTexture(arg1_source, arg2_destination, arg3_copy_size, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void FinishOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_finish");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.finish");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<GPUCommandBufferDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
if (info[0]->IsUndefined()) {
  arg1_descriptor = GPUCommandBufferDescriptor::Create();
} else {
  ExceptionState exception_state(isolate);
arg1_descriptor = NativeValueTraits<GPUCommandBufferDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->finish(arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<GPUCommandBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void InsertDebugMarkerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_insertDebugMarker");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.insertDebugMarker");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_marker_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->insertDebugMarker(arg1_marker_label);

}

void PopDebugGroupOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();
}

void PopDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_popDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.popDebugGroup");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->popDebugGroup();

}

void PushDebugGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_pushDebugGroup");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.pushDebugGroup");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_group_label = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pushDebugGroup(arg1_group_label);

}

void ResolveQuerySetOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_query_set, uint32_t v8_arg2_first_query, uint32_t v8_arg3_query_count, v8::Local<v8::Value> v8_arg4_destination, uint64_t v8_arg5_destination_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, v8_arg1_query_set, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_first_query = v8_arg2_first_query;
auto&& arg3_query_count = v8_arg3_query_count;
auto&& arg4_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 3, v8_arg4_destination, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_destination_offset = v8_arg5_destination_offset;
blink_receiver->resolveQuerySet(arg1_query_set, arg2_first_query, arg3_query_count, arg4_destination, arg5_destination_offset);
}

void ResolveQuerySetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_resolveQuerySet");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.resolveQuerySet");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_first_query = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_query_count = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_destination = NativeValueTraits<GPUBuffer>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_destination_offset = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->resolveQuerySet(arg1_query_set, arg2_first_query, arg3_query_count, arg4_destination, arg5_destination_offset);

}

void WriteTimestampOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_query_set, uint32_t v8_arg2_query_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, v8_arg1_query_set, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query_index = v8_arg2_query_index;
blink_receiver->writeTimestamp(arg1_query_set, arg2_query_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void WriteTimestampOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_GPUCommandEncoder_writeTimestamp");
BLINK_BINDINGS_TRACE_EVENT("GPUCommandEncoder.writeTimestamp");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
GPUCommandEncoder* blink_receiver = V8GPUCommandEncoder::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query_set = NativeValueTraits<GPUQuerySet>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query_index = NativeValueTraits<IDLUnsignedLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->writeTimestamp(arg1_query_set, arg2_query_index, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_gpu_command_encoder

using namespace v8_gpu_command_encoder;

}  // namespace 

void V8GPUCommandEncoder::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8GPUCommandEncoder::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8GPUCommandEncoder::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"label", LabelAttributeGetCallback, LabelAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUCommandEncoder", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"beginComputePass", BeginComputePassOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"beginRenderPass", BeginRenderPassOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyBufferToTexture", CopyBufferToTextureOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTextureToBuffer", CopyTextureToBufferOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTextureToTexture", CopyTextureToTextureOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"finish", FinishOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"insertDebugMarker", InsertDebugMarkerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pushDebugGroup", PushDebugGroupOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUCommandEncoder", kOperationTable);
}


{
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clearBuffer", ClearBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyBufferToBuffer", CopyBufferToBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"resolveQuerySet", ResolveQuerySetOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = ClearBufferOperationNoAllocDirectCallArg3;
std::ignore = ClearBufferOperationNoAllocDirectCallArg2;
std::ignore = ClearBufferOperationNoAllocDirectCallArg1;
std::ignore = CopyBufferToBufferOperationNoAllocDirectCallOverload1Arg3;
std::ignore = CopyBufferToBufferOperationNoAllocDirectCallOverload1Arg2;
std::ignore = CopyBufferToBufferOperationNoAllocDirectCallOverload2Arg5;
std::ignore = CopyBufferToBufferOperationNoAllocDirectCallOverload2Arg4;
std::ignore = PopDebugGroupOperationNoAllocDirectCallArg0;
std::ignore = ResolveQuerySetOperationNoAllocDirectCallArg5;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearBuffer[] = {
v8::CFunctionBuilder().Fn(ClearBufferOperationNoAllocDirectCallArg3).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(ClearBufferOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(ClearBufferOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfCopyBufferToBuffer[] = {
v8::CFunctionBuilder().Fn(CopyBufferToBufferOperationNoAllocDirectCallOverload1Arg3).Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(CopyBufferToBufferOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(CopyBufferToBufferOperationNoAllocDirectCallOverload2Arg5).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(CopyBufferToBufferOperationNoAllocDirectCallOverload2Arg4).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfPopDebugGroup[] = {
v8::CFunctionBuilder().Fn(PopDebugGroupOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfResolveQuerySet[] = {
v8::CFunctionBuilder().Fn(ResolveQuerySetOperationNoAllocDirectCallArg5).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"clearBuffer", ClearBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearBuffer, std::size(kNoAllocDirectCallOverloadsOfClearBuffer)}, 
{{"copyBufferToBuffer", CopyBufferToBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfCopyBufferToBuffer, std::size(kNoAllocDirectCallOverloadsOfCopyBufferToBuffer)}, 
{{"popDebugGroup", PopDebugGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfPopDebugGroup, std::size(kNoAllocDirectCallOverloadsOfPopDebugGroup)}, 
{{"resolveQuerySet", ResolveQuerySetOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfResolveQuerySet, std::size(kNoAllocDirectCallOverloadsOfResolveQuerySet)}, 
};
#endif  // defined(ARCH_CPU_X86)
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUCommandEncoder", kOperationTable);
}


}

void V8GPUCommandEncoder::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;






if (RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled()) {
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"writeTimestamp", WriteTimestampOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = WriteTimestampOperationNoAllocDirectCallArg2;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfWriteTimestamp[] = {
v8::CFunctionBuilder().Fn(WriteTimestampOperationNoAllocDirectCallArg2).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"writeTimestamp", WriteTimestampOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfWriteTimestamp, std::size(kNoAllocDirectCallOverloadsOfWriteTimestamp)}, 
};
#endif  // defined(ARCH_CPU_X86)
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "GPUCommandEncoder", kOperationTable);
}

}



}  // namespace blink
