// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_CANVAS_TONE_MAPPING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_CANVAS_TONE_MAPPING_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_tone_mapping_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUCanvasToneMapping : public bindings::DictionaryBase {
  
  public:
static GPUCanvasToneMapping* Create() {
  return MakeGarbageCollected<GPUCanvasToneMapping>();
}
static GPUCanvasToneMapping* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUCanvasToneMapping>(isolate);
}
static GPUCanvasToneMapping* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUCanvasToneMapping();
explicit  GPUCanvasToneMapping(v8::Isolate* isolate);

bool hasMode() const {
  return true;
}
V8GPUCanvasToneMappingMode mode() const {
  return member_mode_;
}
void setMode(V8GPUCanvasToneMappingMode value) {
  member_mode_ = value;
}
void setMode(V8GPUCanvasToneMappingMode::Enum value) {
  member_mode_ = V8GPUCanvasToneMappingMode(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8GPUCanvasToneMappingMode member_mode_{V8GPUCanvasToneMappingMode::Enum::kStandard};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_CANVAS_TONE_MAPPING_H_
