// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ENCRYPTION_PATTERN_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ENCRYPTION_PATTERN_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT EncryptionPattern : public bindings::InputDictionaryBase {
  
  public:
static EncryptionPattern* Create() {
  return MakeGarbageCollected<EncryptionPattern>();
}
static EncryptionPattern* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<EncryptionPattern>(isolate);
}
static EncryptionPattern* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  EncryptionPattern();
explicit  EncryptionPattern(v8::Isolate* isolate);

bool hasCryptByteBlock() const {
  return true;
}
uint32_t cryptByteBlock() const {
  return member_crypt_byte_block_;
}
void setCryptByteBlock(uint32_t value) {
  member_crypt_byte_block_ = value;
}

bool hasSkipByteBlock() const {
  return true;
}
uint32_t skipByteBlock() const {
  return member_skip_byte_block_;
}
void setSkipByteBlock(uint32_t value) {
  member_skip_byte_block_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_crypt_byte_block_;
uint32_t member_skip_byte_block_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ENCRYPTION_PATTERN_H_
