// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authenticator_attestation_response_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"attestationObject",
"authenticatorData",
"clientDataJSON",
"publicKey",
"publicKeyAlgorithm",
"transports",
};


}  // namespace 

AuthenticatorAttestationResponseJSON* AuthenticatorAttestationResponseJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticatorAttestationResponseJSON* dictionary = MakeGarbageCollected<AuthenticatorAttestationResponseJSON>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticatorAttestationResponseJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticatorAttestationResponseJSON::AuthenticatorAttestationResponseJSON() {
  
}

 AuthenticatorAttestationResponseJSON::AuthenticatorAttestationResponseJSON(v8::Isolate* isolate) {
  
}



void AuthenticatorAttestationResponseJSON::setAttestationObject(const String& value) {
  member_attestation_object_ = value;
}

void AuthenticatorAttestationResponseJSON::setAttestationObject(String&& value) {
  member_attestation_object_ = std::move(value);
}




void AuthenticatorAttestationResponseJSON::setAuthenticatorData(const String& value) {
  member_authenticator_data_ = value;
}

void AuthenticatorAttestationResponseJSON::setAuthenticatorData(String&& value) {
  member_authenticator_data_ = std::move(value);
}




void AuthenticatorAttestationResponseJSON::setClientDataJSON(const String& value) {
  member_client_data_js_on_ = value;
}

void AuthenticatorAttestationResponseJSON::setClientDataJSON(String&& value) {
  member_client_data_js_on_ = std::move(value);
}




String AuthenticatorAttestationResponseJSON::getPublicKeyOr(const String& fallback_value) const {
  if (!hasPublicKey()) {
  return fallback_value;
}
return member_public_key_;
}

String AuthenticatorAttestationResponseJSON::getPublicKeyOr(String&& fallback_value) const {
  if (!hasPublicKey()) {
  return std::move(fallback_value);
}
return member_public_key_;
}

void AuthenticatorAttestationResponseJSON::setPublicKey(const String& value) {
  member_public_key_ = value;
has_public_key_ = true;
}

void AuthenticatorAttestationResponseJSON::setPublicKey(String&& value) {
  member_public_key_ = std::move(value);
has_public_key_ = true;
}









void AuthenticatorAttestationResponseJSON::setTransports(const Vector<String>& value) {
  member_transports_ = value;
}

void AuthenticatorAttestationResponseJSON::setTransports(Vector<String>&& value) {
  member_transports_ = std::move(value);
}



void AuthenticatorAttestationResponseJSON::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void AuthenticatorAttestationResponseJSON::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuthenticatorAttestationResponseJSON::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAttestationObject()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_attestation_object_);
DCHECK(!values[0].IsEmpty());
}
if (hasAuthenticatorData()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_authenticator_data_);
DCHECK(!values[1].IsEmpty());
}
if (hasClientDataJSON()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_client_data_js_on_);
DCHECK(!values[2].IsEmpty());
}
if (hasPublicKey()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_public_key_);
DCHECK(!values[3].IsEmpty());
}
if (hasPublicKeyAlgorithm()) {
  values[4] = ToV8Traits<IDLLongLong>::ToV8(script_state, member_public_key_algorithm_);
DCHECK(!values[4].IsEmpty());
}
if (hasTransports()) {
  values[5] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_transports_);
DCHECK(!values[5].IsEmpty());
}
}

const void* AuthenticatorAttestationResponseJSON::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuthenticatorAttestationResponseJSON::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuthenticatorAttestationResponseJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticatorAttestationResponseJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("attestationObject");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_attestation_object_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("authenticatorData");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_authenticator_data_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("clientDataJSON");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_client_data_js_on_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("publicKey");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_public_key_, member_public_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("publicKeyAlgorithm");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_public_key_algorithm_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transports");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_transports_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticatorAttestationResponseJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
