// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_payment_inputs.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_parameters.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"browserBoundPubKeyCredParams",
"isPayment",
};


}  // namespace 

AuthenticationExtensionsPaymentInputs* AuthenticationExtensionsPaymentInputs::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsPaymentInputs* dictionary = MakeGarbageCollected<AuthenticationExtensionsPaymentInputs>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsPaymentInputs";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsPaymentInputs::AuthenticationExtensionsPaymentInputs() {
  
}

 AuthenticationExtensionsPaymentInputs::AuthenticationExtensionsPaymentInputs(v8::Isolate* isolate) {
  
}



HeapVector<Member<PublicKeyCredentialParameters>> AuthenticationExtensionsPaymentInputs::getBrowserBoundPubKeyCredParamsOr(const HeapVector<Member<PublicKeyCredentialParameters>>& fallback_value) const {
  if (!hasBrowserBoundPubKeyCredParams()) {
  return fallback_value;
}
return member_browser_bound_pub_key_cred_params_;
}

HeapVector<Member<PublicKeyCredentialParameters>> AuthenticationExtensionsPaymentInputs::getBrowserBoundPubKeyCredParamsOr(HeapVector<Member<PublicKeyCredentialParameters>>&& fallback_value) const {
  if (!hasBrowserBoundPubKeyCredParams()) {
  return std::move(fallback_value);
}
return member_browser_bound_pub_key_cred_params_;
}

void AuthenticationExtensionsPaymentInputs::setBrowserBoundPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value) {
  member_browser_bound_pub_key_cred_params_ = value;
has_browser_bound_pub_key_cred_params_ = true;
}

void AuthenticationExtensionsPaymentInputs::setBrowserBoundPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value) {
  member_browser_bound_pub_key_cred_params_ = std::move(value);
has_browser_bound_pub_key_cred_params_ = true;
}










void AuthenticationExtensionsPaymentInputs::Trace(Visitor* visitor) const {
  visitor->Trace(member_browser_bound_pub_key_cred_params_);
bindings::DictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsPaymentInputs::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuthenticationExtensionsPaymentInputs::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (RuntimeEnabledFeatures::SecurePaymentConfirmationBrowserBoundKeysEnabled()) {
  if (hasBrowserBoundPubKeyCredParams()) {
  values[0] = ToV8Traits<IDLSequence<PublicKeyCredentialParameters>>::ToV8(script_state, member_browser_bound_pub_key_cred_params_);
DCHECK(!values[0].IsEmpty());
}
}
if (hasIsPayment()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_payment_);
DCHECK(!values[1].IsEmpty());
}
}

const void* AuthenticationExtensionsPaymentInputs::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuthenticationExtensionsPaymentInputs::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuthenticationExtensionsPaymentInputs::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsPaymentInputs";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::SecurePaymentConfirmationBrowserBoundKeysEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("browserBoundPubKeyCredParams");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialParameters>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_browser_bound_pub_key_cred_params_, member_browser_bound_pub_key_cred_params_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("isPayment");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_is_payment_, member_is_payment_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsPaymentInputs::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
