// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_outputs_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_credential_properties_output.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"appid",
"credBlob",
"credProps",
"getCredBlob",
"hmacCreateSecret",
"largeBlob",
"prf",
"supplementalPubKeys",
};


}  // namespace 

AuthenticationExtensionsClientOutputsJSON* AuthenticationExtensionsClientOutputsJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsClientOutputsJSON* dictionary = MakeGarbageCollected<AuthenticationExtensionsClientOutputsJSON>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsClientOutputsJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsClientOutputsJSON::AuthenticationExtensionsClientOutputsJSON() {
  
}

 AuthenticationExtensionsClientOutputsJSON::AuthenticationExtensionsClientOutputsJSON(v8::Isolate* isolate) {
  
}
























String AuthenticationExtensionsClientOutputsJSON::getGetCredBlobOr(const String& fallback_value) const {
  if (!hasGetCredBlob()) {
  return fallback_value;
}
return member_get_cred_blob_;
}

String AuthenticationExtensionsClientOutputsJSON::getGetCredBlobOr(String&& fallback_value) const {
  if (!hasGetCredBlob()) {
  return std::move(fallback_value);
}
return member_get_cred_blob_;
}

void AuthenticationExtensionsClientOutputsJSON::setGetCredBlob(const String& value) {
  member_get_cred_blob_ = value;
has_get_cred_blob_ = true;
}

void AuthenticationExtensionsClientOutputsJSON::setGetCredBlob(String&& value) {
  member_get_cred_blob_ = std::move(value);
has_get_cred_blob_ = true;
}































void AuthenticationExtensionsClientOutputsJSON::Trace(Visitor* visitor) const {
  visitor->Trace(member_cred_props_);
visitor->Trace(member_large_blob_);
visitor->Trace(member_prf_);
visitor->Trace(member_supplemental_pub_keys_);
bindings::DictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsClientOutputsJSON::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuthenticationExtensionsClientOutputsJSON::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAppid()) {
  values[0] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_appid_);
DCHECK(!values[0].IsEmpty());
}
if (hasCredBlob()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_cred_blob_);
DCHECK(!values[1].IsEmpty());
}
if (hasCredProps()) {
  values[2] = ToV8Traits<CredentialPropertiesOutput>::ToV8(script_state, member_cred_props_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasGetCredBlob()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_get_cred_blob_);
DCHECK(!values[3].IsEmpty());
}
if (hasHmacCreateSecret()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_hmac_create_secret_);
DCHECK(!values[4].IsEmpty());
}
if (hasLargeBlob()) {
  values[5] = ToV8Traits<IDLObject>::ToV8(script_state, member_large_blob_);
DCHECK(!values[5].IsEmpty());
}
if (hasPrf()) {
  values[6] = ToV8Traits<IDLObject>::ToV8(script_state, member_prf_);
DCHECK(!values[6].IsEmpty());
}
if (RuntimeEnabledFeatures::WebAuthenticationSupplementalPubKeysEnabled()) {
  if (hasSupplementalPubKeys()) {
  values[7] = ToV8Traits<IDLObject>::ToV8(script_state, member_supplemental_pub_keys_);
DCHECK(!values[7].IsEmpty());
}
}
}

const void* AuthenticationExtensionsClientOutputsJSON::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuthenticationExtensionsClientOutputsJSON::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuthenticationExtensionsClientOutputsJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsClientOutputsJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("appid");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_appid_, member_appid_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credBlob");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_cred_blob_, member_cred_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credProps");
if (!bindings::GetDictionaryMemberFromV8Object<CredentialPropertiesOutput, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_cred_props_, member_cred_props_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("getCredBlob");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_get_cred_blob_, member_get_cred_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hmacCreateSecret");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_hmac_create_secret_, member_hmac_create_secret_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("largeBlob");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_large_blob_, member_large_blob_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("prf");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_prf_, member_prf_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebAuthenticationSupplementalPubKeysEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("supplementalPubKeys");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_supplemental_pub_keys_, member_supplemental_pub_keys_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsClientOutputsJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
