// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_PARAM_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_PARAM_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_automation_rate.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioParamDescriptor : public bindings::DictionaryBase {
  
  public:
static AudioParamDescriptor* Create() {
  return MakeGarbageCollected<AudioParamDescriptor>();
}
static AudioParamDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioParamDescriptor>(isolate);
}
static AudioParamDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioParamDescriptor();
explicit  AudioParamDescriptor(v8::Isolate* isolate);

bool hasAutomationRate() const {
  return true;
}
V8AutomationRate automationRate() const {
  return member_automation_rate_;
}
void setAutomationRate(V8AutomationRate value) {
  member_automation_rate_ = value;
}
void setAutomationRate(V8AutomationRate::Enum value) {
  member_automation_rate_ = V8AutomationRate(value);
}

bool hasDefaultValue() const {
  return true;
}
float defaultValue() const {
  return member_default_value_;
}
void setDefaultValue(float value) {
  member_default_value_ = value;
}

bool hasMaxValue() const {
  return true;
}
float maxValue() const {
  return member_max_value_;
}
void setMaxValue(float value) {
  member_max_value_ = value;
}

bool hasMinValue() const {
  return true;
}
float minValue() const {
  return member_min_value_;
}
void setMinValue(float value) {
  member_min_value_ = value;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8AutomationRate member_automation_rate_{V8AutomationRate::Enum::kARate};
float member_default_value_{0};
float member_max_value_{3.4028235e38};
float member_min_value_{-3.4028235e38};
String member_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_PARAM_DESCRIPTOR_H_
