// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_REPORT_BUYER_DEBUG_MODE_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_REPORT_BUYER_DEBUG_MODE_CONFIG_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuctionReportBuyerDebugModeConfig : public bindings::InputDictionaryBase {
  
  public:
static AuctionReportBuyerDebugModeConfig* Create() {
  return MakeGarbageCollected<AuctionReportBuyerDebugModeConfig>();
}
static AuctionReportBuyerDebugModeConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuctionReportBuyerDebugModeConfig>(isolate);
}
static AuctionReportBuyerDebugModeConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuctionReportBuyerDebugModeConfig();
explicit  AuctionReportBuyerDebugModeConfig(v8::Isolate* isolate);

bool hasDebugKey() const {
  return has_debug_key_;
}
const std::optional<BigInt>& debugKey() const {
  DCHECK(hasDebugKey());
return member_debug_key_;
}
std::optional<BigInt> getDebugKeyOr(const std::optional<BigInt>& fallback_value) const {
  if (!hasDebugKey()) {
  return fallback_value;
}
return member_debug_key_;
}
void setDebugKey(const std::optional<BigInt>& value) {
  member_debug_key_ = value;
has_debug_key_ = true;
}
void setDebugKey(const BigInt& value) {
  member_debug_key_ = value;
has_debug_key_ = true;
}

bool hasEnabled() const {
  return true;
}
bool enabled() const {
  return member_enabled_;
}
void setEnabled(bool value) {
  member_enabled_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_debug_key_ = false;

std::optional<BigInt> member_debug_key_;
bool member_enabled_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_REPORT_BUYER_DEBUG_MODE_CONFIG_H_
