// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group_size.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"height",
"width",
};


}  // namespace 

AuctionAdInterestGroupSize* AuctionAdInterestGroupSize::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuctionAdInterestGroupSize* dictionary = MakeGarbageCollected<AuctionAdInterestGroupSize>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuctionAdInterestGroupSize";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuctionAdInterestGroupSize::AuctionAdInterestGroupSize() {
  
}

 AuctionAdInterestGroupSize::AuctionAdInterestGroupSize(v8::Isolate* isolate) {
  
}



void AuctionAdInterestGroupSize::setHeight(const String& value) {
  member_height_ = value;
}

void AuctionAdInterestGroupSize::setHeight(String&& value) {
  member_height_ = std::move(value);
}




void AuctionAdInterestGroupSize::setWidth(const String& value) {
  member_width_ = value;
}

void AuctionAdInterestGroupSize::setWidth(String&& value) {
  member_width_ = std::move(value);
}



void AuctionAdInterestGroupSize::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void AuctionAdInterestGroupSize::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AuctionAdInterestGroupSize::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasHeight()) {
  values[0] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_height_);
DCHECK(!values[0].IsEmpty());
}
if (hasWidth()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_width_);
DCHECK(!values[1].IsEmpty());
}
}

const void* AuctionAdInterestGroupSize::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AuctionAdInterestGroupSize::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AuctionAdInterestGroupSize::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuctionAdInterestGroupSize";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("height");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuctionAdInterestGroupSize::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
