// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ANALYSER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ANALYSER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AnalyserOptions : public AudioNodeOptions {
  
  public:
static AnalyserOptions* Create() {
  return MakeGarbageCollected<AnalyserOptions>();
}
static AnalyserOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AnalyserOptions>(isolate);
}
static AnalyserOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AnalyserOptions();
explicit  AnalyserOptions(v8::Isolate* isolate);

bool hasFftSize() const {
  return true;
}
uint32_t fftSize() const {
  return member_fft_size_;
}
void setFftSize(uint32_t value) {
  member_fft_size_ = value;
}

bool hasMaxDecibels() const {
  return true;
}
double maxDecibels() const {
  return member_max_decibels_;
}
void setMaxDecibels(double value) {
  member_max_decibels_ = value;
}

bool hasMinDecibels() const {
  return true;
}
double minDecibels() const {
  return member_min_decibels_;
}
void setMinDecibels(double value) {
  member_min_decibels_ = value;
}

bool hasSmoothingTimeConstant() const {
  return true;
}
double smoothingTimeConstant() const {
  return member_smoothing_time_constant_;
}
void setSmoothingTimeConstant(double value) {
  member_smoothing_time_constant_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_fft_size_{2048};
double member_max_decibels_{-30};
double member_min_decibels_{-100};
double member_smoothing_time_constant_{0.8};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ANALYSER_OPTIONS_H_
