// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_URLPATTERN_URLPATTERNINIT_USVSTRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_URLPATTERN_URLPATTERNINIT_USVSTRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ScriptState;
class URLPattern;
class URLPatternInit;
class V8UnionURLPatternInitOrUSVString;

class CORE_EXPORT V8UnionURLPatternOrURLPatternInitOrUSVString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kURLPattern, kURLPatternInit, kUSVString
};

static V8UnionURLPatternOrURLPatternInitOrUSVString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionURLPatternOrURLPatternInitOrUSVString(URLPattern* value) : content_type_(ContentType::kURLPattern), member_url_pattern_(value) {
  DCHECK(value);
}
explicit  V8UnionURLPatternOrURLPatternInitOrUSVString(URLPatternInit* value) : content_type_(ContentType::kURLPatternInit), member_url_pattern_init_(value) {
  DCHECK(value);
}
explicit  V8UnionURLPatternOrURLPatternInitOrUSVString(const String& value);
explicit  V8UnionURLPatternOrURLPatternInitOrUSVString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsURLPattern() const {
  return content_type_ == ContentType::kURLPattern;
}
URLPattern* GetAsURLPattern() const {
  DCHECK_EQ(content_type_, ContentType::kURLPattern);
return member_url_pattern_.Get();
}
void Set(URLPattern* value) {
  DCHECK(value);
Clear();
member_url_pattern_ = value;
content_type_ = ContentType::kURLPattern;
}

bool IsURLPatternInit() const {
  return content_type_ == ContentType::kURLPatternInit;
}
URLPatternInit* GetAsURLPatternInit() const {
  DCHECK_EQ(content_type_, ContentType::kURLPatternInit);
return member_url_pattern_init_.Get();
}
void Set(URLPatternInit* value) {
  DCHECK(value);
Clear();
member_url_pattern_init_ = value;
content_type_ = ContentType::kURLPatternInit;
}

bool IsUSVString() const {
  return content_type_ == ContentType::kUSVString;
}
const String& GetAsUSVString() const {
  DCHECK_EQ(content_type_, ContentType::kUSVString);
return member_usv_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionURLPatternInitOrUSVString() const {
  return content_type_ == ContentType::kURLPatternInit || content_type_ == ContentType::kUSVString;
}
V8UnionURLPatternInitOrUSVString* GetAsV8UnionURLPatternInitOrUSVString() const;
void Set(const V8UnionURLPatternInitOrUSVString* value);
bool IsV8URLPatternInput() const {
  return IsV8UnionURLPatternInitOrUSVString();
}
V8UnionURLPatternInitOrUSVString* GetAsV8URLPatternInput() const {
  return GetAsV8UnionURLPatternInitOrUSVString();
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(URLPattern or URLPatternInit or USVString)";
}

ContentType content_type_;

Member<URLPattern> member_url_pattern_;
Member<URLPatternInit> member_url_pattern_init_;
String member_usv_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_URLPATTERN_URLPATTERNINIT_USVSTRING_H_
