// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_SANITIZERCONFIG_SANITIZERPRESETS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_SANITIZERCONFIG_SANITIZERPRESETS_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_presets.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class SanitizerConfig;
class ScriptState;

class CORE_EXPORT V8UnionSanitizerConfigOrSanitizerPresets final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kSanitizerConfig, kSanitizerPresets
};

static V8UnionSanitizerConfigOrSanitizerPresets* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionSanitizerConfigOrSanitizerPresets(SanitizerConfig* value) : content_type_(ContentType::kSanitizerConfig), member_sanitizer_config_(value) {
  DCHECK(value);
}
explicit  V8UnionSanitizerConfigOrSanitizerPresets(V8SanitizerPresets value) : content_type_(ContentType::kSanitizerPresets), member_sanitizer_presets_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsSanitizerConfig() const {
  return content_type_ == ContentType::kSanitizerConfig;
}
SanitizerConfig* GetAsSanitizerConfig() const {
  DCHECK_EQ(content_type_, ContentType::kSanitizerConfig);
return member_sanitizer_config_.Get();
}
void Set(SanitizerConfig* value) {
  DCHECK(value);
Clear();
member_sanitizer_config_ = value;
content_type_ = ContentType::kSanitizerConfig;
}

bool IsSanitizerPresets() const {
  return content_type_ == ContentType::kSanitizerPresets;
}
V8SanitizerPresets GetAsSanitizerPresets() const {
  DCHECK_EQ(content_type_, ContentType::kSanitizerPresets);
return member_sanitizer_presets_;
}
void Set(V8SanitizerPresets value) {
  Clear();
member_sanitizer_presets_ = value;
content_type_ = ContentType::kSanitizerPresets;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(SanitizerConfig or SanitizerPresets)";
}

ContentType content_type_;

Member<SanitizerConfig> member_sanitizer_config_;
V8SanitizerPresets member_sanitizer_presets_{static_cast<V8SanitizerPresets::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_SANITIZERCONFIG_SANITIZERPRESETS_H_
