// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_sanitizer_sanitizerconfig_sanitizerpresets.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_config.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_sanitizerconfig_sanitizerpresets.h"
#include "third_party/blink/renderer/core/sanitizer/sanitizer.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets* V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = SanitizerConfig::Create(isolate);
return MakeGarbageCollected<V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets>(blink_value);
}
if (V8Sanitizer::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Sanitizer::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<SanitizerConfig>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<V8SanitizerPresets>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets>(blink_value);
}
}













V8UnionSanitizerConfigOrSanitizerPresets* V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets::GetAsV8UnionSanitizerConfigOrSanitizerPresets() const {
  switch (content_type_) {
  case ContentType::kSanitizerConfig: {
    return MakeGarbageCollected<V8UnionSanitizerConfigOrSanitizerPresets>(GetAsSanitizerConfig());
  }
  case ContentType::kSanitizerPresets: {
    return MakeGarbageCollected<V8UnionSanitizerConfigOrSanitizerPresets>(GetAsSanitizerPresets());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets::Set(const V8UnionSanitizerConfigOrSanitizerPresets* value) {
  switch (value->GetContentType()) {
  case V8UnionSanitizerConfigOrSanitizerPresets::ContentType::kSanitizerConfig: {
    Set(value->GetAsSanitizerConfig());
    break;
  }
  case V8UnionSanitizerConfigOrSanitizerPresets::ContentType::kSanitizerPresets: {
    Set(value->GetAsSanitizerPresets());
    break;
  }
}
}


void V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets::Trace(Visitor* visitor) const {
  visitor->Trace(member_sanitizer_);
visitor->Trace(member_sanitizer_config_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionSanitizerOrSanitizerConfigOrSanitizerPresets::Clear() {
  member_sanitizer_.Clear();
member_sanitizer_config_.Clear();
}



}  // namespace blink
