// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_readablebytestreamcontroller_readablestreamdefaultcontroller.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/core/streams/readable_byte_stream_controller.h"
#include "third_party/blink/renderer/core/streams/readable_stream_default_controller.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionReadableByteStreamControllerOrReadableStreamDefaultController* V8UnionReadableByteStreamControllerOrReadableStreamDefaultController::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8ReadableStreamDefaultController::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ReadableStreamDefaultController::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionReadableByteStreamControllerOrReadableStreamDefaultController>(blink_value);
}
if (V8ReadableByteStreamController::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ReadableByteStreamController::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionReadableByteStreamControllerOrReadableStreamDefaultController>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionReadableByteStreamControllerOrReadableStreamDefaultController::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kReadableByteStreamController: {
    return ToV8Traits<ReadableByteStreamController>::ToV8(script_state, member_readable_byte_stream_controller_.Get());
  }
  case ContentType::kReadableStreamDefaultController: {
    return ToV8Traits<ReadableStreamDefaultController>::ToV8(script_state, member_readable_stream_default_controller_.Get());
  }
}

NOTREACHED();
}

void V8UnionReadableByteStreamControllerOrReadableStreamDefaultController::Trace(Visitor* visitor) const {
  visitor->Trace(member_readable_byte_stream_controller_);
visitor->Trace(member_readable_stream_default_controller_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionReadableByteStreamControllerOrReadableStreamDefaultController::Clear() {
  member_readable_byte_stream_controller_.Clear();
member_readable_stream_default_controller_.Clear();
}



}  // namespace blink
