// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOCUMENT_ELEMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOCUMENT_ELEMENT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Document;
class Element;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionDocumentOrElement final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDocument, kElement
};

static V8UnionDocumentOrElement* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDocumentOrElement(Document* value) : content_type_(ContentType::kDocument), member_document_(value) {
  DCHECK(value);
}
explicit  V8UnionDocumentOrElement(Element* value) : content_type_(ContentType::kElement), member_element_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDocument() const {
  return content_type_ == ContentType::kDocument;
}
Document* GetAsDocument() const {
  DCHECK_EQ(content_type_, ContentType::kDocument);
return member_document_.Get();
}
void Set(Document* value) {
  DCHECK(value);
Clear();
member_document_ = value;
content_type_ = ContentType::kDocument;
}

bool IsElement() const {
  return content_type_ == ContentType::kElement;
}
Element* GetAsElement() const {
  DCHECK_EQ(content_type_, ContentType::kElement);
return member_element_.Get();
}
void Set(Element* value) {
  DCHECK(value);
Clear();
member_element_ = value;
content_type_ = ContentType::kElement;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Document or Element)";
}

ContentType content_type_;

Member<Document> member_document_;
Member<Element> member_element_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_DOCUMENT_ELEMENT_H_
