// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CHILDNODEPART_DOCUMENTPARTROOT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CHILDNODEPART_DOCUMENTPARTROOT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ChildNodePart;
class DocumentPartRoot;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionChildNodePartOrDocumentPartRoot final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kChildNodePart, kDocumentPartRoot
};

static V8UnionChildNodePartOrDocumentPartRoot* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionChildNodePartOrDocumentPartRoot(ChildNodePart* value) : content_type_(ContentType::kChildNodePart), member_child_node_part_(value) {
  DCHECK(value);
}
explicit  V8UnionChildNodePartOrDocumentPartRoot(DocumentPartRoot* value) : content_type_(ContentType::kDocumentPartRoot), member_document_part_root_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsChildNodePart() const {
  return content_type_ == ContentType::kChildNodePart;
}
ChildNodePart* GetAsChildNodePart() const {
  DCHECK_EQ(content_type_, ContentType::kChildNodePart);
return member_child_node_part_.Get();
}
void Set(ChildNodePart* value) {
  DCHECK(value);
Clear();
member_child_node_part_ = value;
content_type_ = ContentType::kChildNodePart;
}

bool IsDocumentPartRoot() const {
  return content_type_ == ContentType::kDocumentPartRoot;
}
DocumentPartRoot* GetAsDocumentPartRoot() const {
  DCHECK_EQ(content_type_, ContentType::kDocumentPartRoot);
return member_document_part_root_.Get();
}
void Set(DocumentPartRoot* value) {
  DCHECK(value);
Clear();
member_document_part_root_ = value;
content_type_ = ContentType::kDocumentPartRoot;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ChildNodePart or DocumentPartRoot)";
}

ContentType content_type_;

Member<ChildNodePart> member_child_node_part_;
Member<DocumentPartRoot> member_document_part_root_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_CHILDNODEPART_DOCUMENTPARTROOT_H_
