// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBufferBase>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared>(blink_value);
}
if (v8_value->IsArrayBufferView()) {
  auto&& blink_value = NativeValueTraits<MaybeShared<DOMArrayBufferView>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kArrayBufferAllowShared: {
    return ToV8Traits<DOMArrayBufferBase>::ToV8(script_state, member_array_buffer_allow_shared_.Get());
  }
  case ContentType::kArrayBufferViewAllowShared: {
    return ToV8Traits<MaybeShared<DOMArrayBufferView>>::ToV8(script_state, member_array_buffer_view_allow_shared_);
  }
}

NOTREACHED();
}

void V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_allow_shared_);
visitor->Trace(member_array_buffer_view_allow_shared_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared::Clear() {
  member_array_buffer_allow_shared_.Clear();
member_array_buffer_view_allow_shared_.Clear();
}



}  // namespace blink
