// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_BLOB_FORMDATA_READABLESTREAM_URLSEARCHPARAMS_USVSTRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_BLOB_FORMDATA_READABLESTREAM_URLSEARCHPARAMS_USVSTRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class Blob;
class ExceptionState;
class FormData;
class ReadableStream;
class ScriptState;
class URLSearchParams;
class V8UnionArrayBufferOrArrayBufferView;
class V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString;
class V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString;
class V8UnionArrayBufferOrArrayBufferViewOrUSVString;

class CORE_EXPORT V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kArrayBuffer, kArrayBufferView, kBlob, kFormData, kReadableStream, kURLSearchParams, kUSVString
};

static V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(DOMArrayBuffer* value) : content_type_(ContentType::kArrayBuffer), member_array_buffer_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(NotShared<DOMArrayBufferView> value) : content_type_(ContentType::kArrayBufferView), member_array_buffer_view_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(Blob* value) : content_type_(ContentType::kBlob), member_blob_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(FormData* value) : content_type_(ContentType::kFormData), member_form_data_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(ReadableStream* value) : content_type_(ContentType::kReadableStream), member_readable_stream_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(URLSearchParams* value) : content_type_(ContentType::kURLSearchParams), member_url_search_params_(value) {
  DCHECK(value);
}
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(const String& value);
explicit  V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsArrayBuffer() const {
  return content_type_ == ContentType::kArrayBuffer;
}
DOMArrayBuffer* GetAsArrayBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBuffer);
return member_array_buffer_.Get();
}
void Set(DOMArrayBuffer* value) {
  DCHECK(value);
Clear();
member_array_buffer_ = value;
content_type_ = ContentType::kArrayBuffer;
}

bool IsArrayBufferView() const {
  return content_type_ == ContentType::kArrayBufferView;
}
NotShared<DOMArrayBufferView> GetAsArrayBufferView() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBufferView);
return member_array_buffer_view_;
}
void Set(NotShared<DOMArrayBufferView> value) {
  DCHECK(value);
Clear();
member_array_buffer_view_ = value;
content_type_ = ContentType::kArrayBufferView;
}

bool IsBlob() const {
  return content_type_ == ContentType::kBlob;
}
Blob* GetAsBlob() const {
  DCHECK_EQ(content_type_, ContentType::kBlob);
return member_blob_.Get();
}
void Set(Blob* value) {
  DCHECK(value);
Clear();
member_blob_ = value;
content_type_ = ContentType::kBlob;
}

bool IsFormData() const {
  return content_type_ == ContentType::kFormData;
}
FormData* GetAsFormData() const {
  DCHECK_EQ(content_type_, ContentType::kFormData);
return member_form_data_.Get();
}
void Set(FormData* value) {
  DCHECK(value);
Clear();
member_form_data_ = value;
content_type_ = ContentType::kFormData;
}

bool IsReadableStream() const {
  return content_type_ == ContentType::kReadableStream;
}
ReadableStream* GetAsReadableStream() const {
  DCHECK_EQ(content_type_, ContentType::kReadableStream);
return member_readable_stream_.Get();
}
void Set(ReadableStream* value) {
  DCHECK(value);
Clear();
member_readable_stream_ = value;
content_type_ = ContentType::kReadableStream;
}

bool IsURLSearchParams() const {
  return content_type_ == ContentType::kURLSearchParams;
}
URLSearchParams* GetAsURLSearchParams() const {
  DCHECK_EQ(content_type_, ContentType::kURLSearchParams);
return member_url_search_params_.Get();
}
void Set(URLSearchParams* value) {
  DCHECK(value);
Clear();
member_url_search_params_ = value;
content_type_ = ContentType::kURLSearchParams;
}

bool IsUSVString() const {
  return content_type_ == ContentType::kUSVString;
}
const String& GetAsUSVString() const {
  DCHECK_EQ(content_type_, ContentType::kUSVString);
return member_usv_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionArrayBufferOrArrayBufferView() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView;
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8UnionArrayBufferOrArrayBufferView() const;
void Set(const V8UnionArrayBufferOrArrayBufferView* value);
bool IsV8BinaryData() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BinaryData() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}
bool IsV8BufferSource() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BufferSource() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}

bool IsV8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView || content_type_ == ContentType::kBlob || content_type_ == ContentType::kFormData || content_type_ == ContentType::kURLSearchParams || content_type_ == ContentType::kUSVString;
}
V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString* GetAsV8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString() const;
void Set(const V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString* value);
bool IsV8XMLHttpRequestBodyInit() const {
  return IsV8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString();
}
V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString* GetAsV8XMLHttpRequestBodyInit() const {
  return GetAsV8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrURLSearchParamsOrUSVString();
}

bool IsV8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView || content_type_ == ContentType::kBlob || content_type_ == ContentType::kUSVString;
}
V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* GetAsV8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString() const;
void Set(const V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* value);
bool IsV8BlobPart() const {
  return IsV8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString();
}
V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* GetAsV8BlobPart() const {
  return GetAsV8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString();
}

bool IsV8UnionArrayBufferOrArrayBufferViewOrUSVString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView || content_type_ == ContentType::kUSVString;
}
V8UnionArrayBufferOrArrayBufferViewOrUSVString* GetAsV8UnionArrayBufferOrArrayBufferViewOrUSVString() const;
void Set(const V8UnionArrayBufferOrArrayBufferViewOrUSVString* value);
bool IsV8PushMessageDataInit() const {
  return IsV8UnionArrayBufferOrArrayBufferViewOrUSVString();
}
V8UnionArrayBufferOrArrayBufferViewOrUSVString* GetAsV8PushMessageDataInit() const {
  return GetAsV8UnionArrayBufferOrArrayBufferViewOrUSVString();
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ArrayBuffer or ArrayBufferView or Blob or FormData or ReadableStream or URLSearchParams or USVString)";
}

ContentType content_type_;

Member<DOMArrayBuffer> member_array_buffer_;
NotShared<DOMArrayBufferView> member_array_buffer_view_;
Member<Blob> member_blob_;
Member<FormData> member_form_data_;
Member<ReadableStream> member_readable_stream_;
Member<URLSearchParams> member_url_search_params_;
String member_usv_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ARRAYBUFFER_ARRAYBUFFERVIEW_BLOB_FORMDATA_READABLESTREAM_URLSEARCHPARAMS_USVSTRING_H_
