// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TIMELINE_RANGE_OFFSET_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TIMELINE_RANGE_OFFSET_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_timeline_range.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CSSNumericValue;
class ExceptionState;

class CORE_EXPORT TimelineRangeOffset : public bindings::DictionaryBase {
  
  public:
static TimelineRangeOffset* Create() {
  return MakeGarbageCollected<TimelineRangeOffset>();
}
static TimelineRangeOffset* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TimelineRangeOffset>(isolate);
}
static TimelineRangeOffset* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TimelineRangeOffset();
explicit  TimelineRangeOffset(v8::Isolate* isolate);

bool hasOffset() const {
  return has_offset_;
}
CSSNumericValue* offset() const {
  DCHECK(hasOffset());
return member_offset_.Get();
}
CSSNumericValue* getOffsetOr(CSSNumericValue* fallback_value) const {
  if (!hasOffset()) {
  return fallback_value;
}
return member_offset_.Get();
}
void setOffset(CSSNumericValue* value) {
  member_offset_ = value;
has_offset_ = true;
DCHECK(member_offset_);
}

bool hasRangeName() const {
  return has_range_name_;
}
V8TimelineRange rangeName() const {
  DCHECK(hasRangeName());
return member_range_name_;
}
V8TimelineRange getRangeNameOr(V8TimelineRange fallback_value) const {
  if (!hasRangeName()) {
  return fallback_value;
}
return member_range_name_;
}
void setRangeName(V8TimelineRange value) {
  member_range_name_ = value;
has_range_name_ = true;
}
void setRangeName(V8TimelineRange::Enum value) {
  member_range_name_ = V8TimelineRange(value);
has_range_name_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_offset_ = false;
bool has_range_name_ = false;

Member<CSSNumericValue> member_offset_;
V8TimelineRange member_range_name_{static_cast<V8TimelineRange::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TIMELINE_RANGE_OFFSET_H_
