// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHADOW_ROOT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHADOW_ROOT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_shadow_root_mode.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_slot_assignment_mode.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CustomElementRegistry;
class ExceptionState;

class CORE_EXPORT ShadowRootInit : public bindings::InputDictionaryBase {
  
  public:
static ShadowRootInit* Create() {
  return MakeGarbageCollected<ShadowRootInit>();
}
static ShadowRootInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ShadowRootInit>(isolate);
}
static ShadowRootInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ShadowRootInit();
explicit  ShadowRootInit(v8::Isolate* isolate);

bool hasClonable() const {
  return has_clonable_;
}
bool clonable() const {
  DCHECK(hasClonable());
return member_clonable_;
}
bool getClonableOr(bool fallback_value) const {
  if (!hasClonable()) {
  return fallback_value;
}
return member_clonable_;
}
void setClonable(bool value) {
  member_clonable_ = value;
has_clonable_ = true;
}

bool hasCustomElementRegistry() const {
  return has_custom_element_registry_;
}
CustomElementRegistry* customElementRegistry() const {
  DCHECK(hasCustomElementRegistry());
return member_custom_element_registry_.Get();
}
CustomElementRegistry* getCustomElementRegistryOr(CustomElementRegistry* fallback_value) const {
  if (!hasCustomElementRegistry()) {
  return fallback_value;
}
return member_custom_element_registry_.Get();
}
void setCustomElementRegistry(CustomElementRegistry* value) {
  member_custom_element_registry_ = value;
has_custom_element_registry_ = true;
}

bool hasDelegatesFocus() const {
  return has_delegates_focus_;
}
bool delegatesFocus() const {
  DCHECK(hasDelegatesFocus());
return member_delegates_focus_;
}
bool getDelegatesFocusOr(bool fallback_value) const {
  if (!hasDelegatesFocus()) {
  return fallback_value;
}
return member_delegates_focus_;
}
void setDelegatesFocus(bool value) {
  member_delegates_focus_ = value;
has_delegates_focus_ = true;
}

bool hasMode() const {
  return true;
}
V8ShadowRootMode mode() const {
  return member_mode_;
}
void setMode(V8ShadowRootMode value) {
  member_mode_ = value;
}
void setMode(V8ShadowRootMode::Enum value) {
  member_mode_ = V8ShadowRootMode(value);
}

bool hasReferenceTarget() const {
  return has_reference_target_;
}
const String& referenceTarget() const {
  DCHECK(hasReferenceTarget());
return member_reference_target_;
}
String getReferenceTargetOr(const String& fallback_value) const;
String getReferenceTargetOr(String&& fallback_value) const;
void setReferenceTarget(const String& value);
void setReferenceTarget(String&& value);

bool hasSerializable() const {
  return has_serializable_;
}
bool serializable() const {
  DCHECK(hasSerializable());
return member_serializable_;
}
bool getSerializableOr(bool fallback_value) const {
  if (!hasSerializable()) {
  return fallback_value;
}
return member_serializable_;
}
void setSerializable(bool value) {
  member_serializable_ = value;
has_serializable_ = true;
}

bool hasSlotAssignment() const {
  return has_slot_assignment_;
}
V8SlotAssignmentMode slotAssignment() const {
  DCHECK(hasSlotAssignment());
return member_slot_assignment_;
}
V8SlotAssignmentMode getSlotAssignmentOr(V8SlotAssignmentMode fallback_value) const {
  if (!hasSlotAssignment()) {
  return fallback_value;
}
return member_slot_assignment_;
}
void setSlotAssignment(V8SlotAssignmentMode value) {
  member_slot_assignment_ = value;
has_slot_assignment_ = true;
}
void setSlotAssignment(V8SlotAssignmentMode::Enum value) {
  member_slot_assignment_ = V8SlotAssignmentMode(value);
has_slot_assignment_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_clonable_ = false;
bool has_custom_element_registry_ = false;
bool has_delegates_focus_ = false;
bool has_reference_target_ = false;
bool has_serializable_ = false;
bool has_slot_assignment_ = false;

bool member_clonable_;
Member<CustomElementRegistry> member_custom_element_registry_;
bool member_delegates_focus_;
V8ShadowRootMode member_mode_{static_cast<V8ShadowRootMode::Enum>(0)};
String member_reference_target_;
bool member_serializable_;
V8SlotAssignmentMode member_slot_assignment_{static_cast<V8SlotAssignmentMode::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SHADOW_ROOT_INIT_H_
