// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SCROLL_INTO_VIEW_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SCROLL_INTO_VIEW_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scroll_container.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scroll_logical_position.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scroll_options.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ScrollIntoViewOptions : public ScrollOptions {
  
  public:
static ScrollIntoViewOptions* Create() {
  return MakeGarbageCollected<ScrollIntoViewOptions>();
}
static ScrollIntoViewOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ScrollIntoViewOptions>(isolate);
}
static ScrollIntoViewOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ScrollIntoViewOptions();
explicit  ScrollIntoViewOptions(v8::Isolate* isolate);

bool hasBlock() const {
  return true;
}
V8ScrollLogicalPosition block() const {
  return member_block_;
}
void setBlock(V8ScrollLogicalPosition value) {
  member_block_ = value;
}
void setBlock(V8ScrollLogicalPosition::Enum value) {
  member_block_ = V8ScrollLogicalPosition(value);
}

bool hasContainer() const {
  return true;
}
V8ScrollContainer container() const {
  return member_container_;
}
void setContainer(V8ScrollContainer value) {
  member_container_ = value;
}
void setContainer(V8ScrollContainer::Enum value) {
  member_container_ = V8ScrollContainer(value);
}

bool hasInlinePosition() const {
  return true;
}
V8ScrollLogicalPosition inlinePosition() const {
  return member_inline_position_;
}
void setInlinePosition(V8ScrollLogicalPosition value) {
  member_inline_position_ = value;
}
void setInlinePosition(V8ScrollLogicalPosition::Enum value) {
  member_inline_position_ = V8ScrollLogicalPosition(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ScrollOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8ScrollLogicalPosition member_block_{V8ScrollLogicalPosition::Enum::kStart};
V8ScrollContainer member_container_{V8ScrollContainer::Enum::kAll};
V8ScrollLogicalPosition member_inline_position_{V8ScrollLogicalPosition::Enum::kNearest};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SCROLL_INTO_VIEW_OPTIONS_H_
