// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_element_namespace_with_attributes.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_attribute_namespace.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_sanitizerattributenamespace_string.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"attributes",
"removeAttributes",
};


}  // namespace 

SanitizerElementNamespaceWithAttributes* SanitizerElementNamespaceWithAttributes::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SanitizerElementNamespaceWithAttributes* dictionary = MakeGarbageCollected<SanitizerElementNamespaceWithAttributes>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SanitizerElementNamespaceWithAttributes";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SanitizerElementNamespaceWithAttributes::SanitizerElementNamespaceWithAttributes() {
  
}

 SanitizerElementNamespaceWithAttributes::SanitizerElementNamespaceWithAttributes(v8::Isolate* isolate) : SanitizerElementNamespace(isolate) {
  
}



HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerElementNamespaceWithAttributes::getAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const {
  if (!hasAttributes()) {
  return fallback_value;
}
return member_attributes_;
}

HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerElementNamespaceWithAttributes::getAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const {
  if (!hasAttributes()) {
  return std::move(fallback_value);
}
return member_attributes_;
}

void SanitizerElementNamespaceWithAttributes::setAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value) {
  member_attributes_ = value;
has_attributes_ = true;
}

void SanitizerElementNamespaceWithAttributes::setAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value) {
  member_attributes_ = std::move(value);
has_attributes_ = true;
}




HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerElementNamespaceWithAttributes::getRemoveAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const {
  if (!hasRemoveAttributes()) {
  return fallback_value;
}
return member_remove_attributes_;
}

HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> SanitizerElementNamespaceWithAttributes::getRemoveAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const {
  if (!hasRemoveAttributes()) {
  return std::move(fallback_value);
}
return member_remove_attributes_;
}

void SanitizerElementNamespaceWithAttributes::setRemoveAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value) {
  member_remove_attributes_ = value;
has_remove_attributes_ = true;
}

void SanitizerElementNamespaceWithAttributes::setRemoveAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value) {
  member_remove_attributes_ = std::move(value);
has_remove_attributes_ = true;
}



void SanitizerElementNamespaceWithAttributes::Trace(Visitor* visitor) const {
  visitor->Trace(member_attributes_);
visitor->Trace(member_remove_attributes_);
SanitizerElementNamespace::Trace(visitor);
}

void SanitizerElementNamespaceWithAttributes::FillTemplateProperties(Vector<std::string_view>& properties) const {
  SanitizerElementNamespace::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void SanitizerElementNamespaceWithAttributes::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  SanitizerElementNamespace::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAttributes()) {
  values[0] = ToV8Traits<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>>::ToV8(script_state, member_attributes_);
DCHECK(!values[0].IsEmpty());
}
if (hasRemoveAttributes()) {
  values[1] = ToV8Traits<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>>::ToV8(script_state, member_remove_attributes_);
DCHECK(!values[1].IsEmpty());
}
}

const void* SanitizerElementNamespaceWithAttributes::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> SanitizerElementNamespaceWithAttributes::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void SanitizerElementNamespaceWithAttributes::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
SanitizerElementNamespace::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "SanitizerElementNamespaceWithAttributes";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("attributes");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_attributes_, member_attributes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("removeAttributes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionSanitizerAttributeNamespaceOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_remove_attributes_, member_remove_attributes_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SanitizerElementNamespaceWithAttributes::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
