// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_retry_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"backoffFactor",
"initialDelay",
"maxAge",
"maxAttempts",
"retryAfterUnload",
"retryNonIdempotent",
"retryOnlyIfServerUnreached",
};


}  // namespace 

RetryOptions* RetryOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RetryOptions* dictionary = MakeGarbageCollected<RetryOptions>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RetryOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RetryOptions::RetryOptions() {
  
}

 RetryOptions::RetryOptions(v8::Isolate* isolate) {
  
}









































void RetryOptions::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void RetryOptions::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RetryOptions::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBackoffFactor()) {
  values[0] = ToV8Traits<IDLNullable<IDLDouble>>::ToV8(script_state, member_backoff_factor_);
DCHECK(!values[0].IsEmpty());
}
if (hasInitialDelay()) {
  values[1] = ToV8Traits<IDLNullable<IDLUnsignedLong>>::ToV8(script_state, member_initial_delay_);
DCHECK(!values[1].IsEmpty());
}
if (hasMaxAge()) {
  values[2] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_max_age_);
DCHECK(!values[2].IsEmpty());
}
if (hasMaxAttempts()) {
  values[3] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_max_attempts_);
DCHECK(!values[3].IsEmpty());
}
if (hasRetryAfterUnload()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_retry_after_unload_);
DCHECK(!values[4].IsEmpty());
}
if (hasRetryNonIdempotent()) {
  values[5] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_retry_non_idempotent_);
DCHECK(!values[5].IsEmpty());
}
if (hasRetryOnlyIfServerUnreached()) {
  values[6] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_retry_only_if_server_unreached_);
DCHECK(!values[6].IsEmpty());
}
}

const void* RetryOptions::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RetryOptions::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RetryOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RetryOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("backoffFactor");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLDouble>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_backoff_factor_, member_backoff_factor_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("initialDelay");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLUnsignedLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_initial_delay_, member_initial_delay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxAge");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_max_age_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxAttempts");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_max_attempts_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retryAfterUnload");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_retry_after_unload_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retryNonIdempotent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_retry_non_idempotent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("retryOnlyIfServerUnreached");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_retry_only_if_server_unreached_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RetryOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
